var sitSuffixe = "bdm";
var sitNom = "Barreau de Montpellier";
var siteURL = "https://permanence.barreau-montpellier.fr";

function nl2br(str, is_xhtml) {   
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';    
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
}

function retourne(valeur)
{
	return valeur;
}

function getFileIcon(ext)
{
	if(ext == "pdf"){
		return "icon_pdf.png";
	}
	if(ext == "doc" || ext == "docx"){
		return "icon_doc.png";
	}
	if(ext == "tif" || ext == "tiff" || ext == "jpg" || ext == "jpeg" || ext == "gif"){
		return "icon_img.png";
	}
	if(ext == "xls" || ext == "xlsx"){
		return "icon_xls.png";
	}
	if(ext == "zip"){
		return "icon_zip.png";
	}
	return "icon_file.png";
}

function createCORSRequest(method, url)
{
  var xhr = new XMLHttpRequest();
  if ("withCredentials" in xhr) {

	// Check if the XMLHttpRequest object has a "withCredentials" property.
	// "withCredentials" only exists on XMLHTTPRequest2 objects.
	xhr.open(method, url, true);

  } else if (typeof XDomainRequest != "undefined") {

	// Otherwise, check if XDomainRequest.
	// XDomainRequest only exists in IE, and is IE's way of making CORS requests.
	xhr = new XDomainRequest();
	xhr.open(method, url);

  } else {

	// Otherwise, CORS is not supported by the browser.
	xhr = null;

  }
  return xhr;
}

function getCookie(cname)
{
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for(var i = 0; i <ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function createSelect(id, min, max, grow)
{
	if (!id){
		return false;
	}else{
		select = document.getElementById(id);
		if(grow){
			for (var i = min; i<=max; i++){
				var opt = document.createElement('option');
				opt.value = i;
				opt.innerHTML = i;
				select.appendChild(opt);
			}
		}else{
			for (var i = max; i>=min; i--){
				var opt = document.createElement('option');
				opt.value = i;
				opt.innerHTML = i;
				select.appendChild(opt);
			}
		}
	}	
}

function isEmail(email)
{
	var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	return regex.test(email);
}

function isCp(codePostal)
{
	console.log(codePostal.length);
	if(codePostal.length != 5 || isNaN(codePostal)){
		return false;
	}
	return true;
}

function isTel(telephone)
{
	console.log(telephone.length);
	if(telephone.length != 10 || isNaN(telephone)){
		return false;
	}
	return true;
}

function formatTel(tel)
{
	var formatedTel = '';
	var compteur = 0;
	tel = tel.replace(/\s/g, '');
	
	for (var i = 1; i <= tel.length; i++) {
		if(compteur == 2){
			formatedTel += " ";
			compteur = 0;
		}
		formatedTel += tel.charAt(i-1);
		compteur++;
	}
	return formatedTel;
}

function isMobile()
{
	var check = false;
	(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) check = true;})(navigator.userAgent||navigator.vendor||window.opera);
	return check;
}

function isMobileAndTablet()
{
	var check = false;
	(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) check = true;})(navigator.userAgent||navigator.vendor||window.opera);
	return check;
}

function addZero(val)
{
	if(val < 10){
		return "0"+val;
	}else{
		return val;
	}
}

function message(el, message)
{
	var elem = $('#'+el);
	elem.html(message);
}

function returnLitteralMonth(mois)
{
	var annee = ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'];
	return annee[mois-1];
}

function circularMonth(mois)
{
	if(mois > 12){
		var retour = 1;
	}else if(mois < 1){
		var retour = 12;
	}else{
		var retour = mois;
	}
	return retour;
}

function formatDate(date) {
  var day = date.getDate();
  var monthIndex = date.getMonth();
  monthIndex++;
  var year = date.getFullYear();
  return year+'-'+monthIndex+'-'+day;
}

function transBoolean(bool)
{
	if(bool){
		return 1;
	}else{
		return 0;
	}
}

// -------------------------------------------------------------------------------------------- CONNEXION --------------------------------------------------------------------------------------------

function connexion()
{
	console.log('connexion()');
	message("errorConnexion", "");
	
	if($('#login').val() == ""){
		console.log("Login vide");
		message("errorConnexion", "Merci de saisir un Login");
		return false;
	}
	if($('#password').val() == ""){
		console.log("Password vide");
		message("errorConnexion", "Merci de saisir un password");
		return false;
	}
	
	//message("confirmConnexion", "Merci");
	
	var data={};
	data["login"] = $('#login').val();
	data["pwd"] = $('#password').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/connexion.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "cnx ok"){
					window.location.href = siteURL;
				}
				if(msg["content"] == "pwd nok"){
					message("errorConnexion", "Mot de Passe incorrect");
				}
				if(msg["content"] == "noone"){
					message("errorConnexion", "Aucun utilisateur trouvé");
				}
			}
		},
		error: function(msg){
			message("errorConnexion", "Connexion au serveur impossible"+msg[0][0]);
		}
	});
}

function deconnect()
{
	console.log('deconnet()');
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deconnexion.php',
		success: function(msg){
			console.log("Déconnecté !");
			window.location.href = siteURL;
		},
		error: function(msg){
			console.log("ERROR");
		}
	});
}

function retrieve()
{
	console.log('retrieve()');
	message("errorRetrieve", "");
	message("confirmRetrieve", "");
	
	if(!isEmail($('#emailRecup').val())){
		message("errorRetrieve", "Merci de saisir un email valide");
		return false;
	}else{
		var data={};
		data["emailRecup"] = $('#emailRecup').val();
		$.ajax({
			type: 'POST',
			url: siteURL+'/control/retrievePass.php',
			data: { 'data' : data },
			success: function(msg){
				console.log("Mess code : "+msg["code"]);
				console.log("Mess content : "+msg["content"]);
				if(msg["code"] == "NOK"){
					if(msg["content"] == "noone"){
						message("errorRetrieve", "Aucun contact ne correspond à cet Email");
					}
				}else{
					message("confirmRetrieve", "Un Email de récupération de mot de passe a été envoyé à l'adresse indiquée.<br>Cela peut prendre quelques minutes, pensez à vérifier votre boite spam.");
				}
			},
			error: function(msg){
				console.log("ERROR MESSAGE : "+msg["content"]);
			}
		});
	}
}

function pwdReset(id)
{
	console.log('pwdReset('+id+')');
	message("errorReset", "");
	message("confirmReset", "");
	
	if(id == ""){
		message("errorReset", "ID de reset non trouvé");
		return false;
	}		
	
	if($('#password').val() == ""){
		message("errorReset", "Merci de saisir un mot de passse");
		return false;
	}
	if($('#passwordConfirm').val() == ""){
		message("errorReset", "Merci de confirmer le mot de passse");
		return false;
	}
	
	if($('#password').val() != $('#passwordConfirm').val()){
		message("errorReset", "Mauvaise confirmation");
		return false;
	}
	
	var data={};
	data["id"] = id;
	data["pass"] = $('#password').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/resetPass.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "updateds"){
					message("confirmReset", "Votre mot de passe a bien été modifié");
				}
				if(msg["content"] == "noLink"){
					message("errorReset", "Ce lien de modification n'est plus valide");
				}				
				$('#password').val("");
				$('#passwordConfirm').val("");
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorReset", "Pas de connexion au serveur");
		}
	});
}

function pwdChange(id)
{
	console.log('pwdChange('+id+')');
	message("errorReset", "");
	message("confirmReset", "");
	
	if(id == ""){
		message("errorReset", "ID de reset non trouvé");
		return false;
	}		
	
	if($('#passwordOld').val() == ""){
		message("errorReset", "Merci de saisir votre mot de passse actuel");
		return false;
	}
	if($('#password').val() == ""){
		message("errorReset", "Merci de saisir un mot de passse");
		return false;
	}
	if($('#passwordConfirm').val() == ""){
		message("errorReset", "Merci de confirmer le mot de passse");
		return false;
	}
	
	if($('#password').val() != $('#passwordConfirm').val()){
		message("errorReset", "Mauvaise confirmation");
		return false;
	}
	
	var data={};
	data["id"] = id;
	data["passOld"] = $('#passwordOld').val();
	data["pass"] = $('#password').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/changePass.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmReset", msg["content"]);
				$('#passwordOld').val('');
				$('#password').val('');
				$('#passwordConfirm').val('');
			}else{
				message("errorReset", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorReset", "Pas de connexion au serveur");
		}
	});
}

function logChange(id)
{
	console.log('logChange('+id+')');
	message("errorReset", "");
	message("confirmReset", "");
	
	if(id == ""){
		message("errorReset", "ID de reset non trouvé");
		return false;
	}		
	
	if($('#newLogin').val() == ""){
		message("errorReset", "Merci de saisir un login");
		return false;
	}
	
	var data={};
	data["id"] = id;
	data["login"] = $('#newLogin').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/changeLog.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmReset", msg["content"]);
				$('#newLogin').val('');
			}else{
				message("errorReset", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorReset", "Pas de connexion au serveur");
		}
	});
	
}

// -------------------------------------------------------------------------------------------- BASE --------------------------------------------------------------------------------------------

function uploadBase(el, target)
{
	console.log('uploadBase()');
	message("errorMajBase", "");
	message("confirmMajBase", "");
	$(".loader").css("display", "block");
	
	var elem = $( "#"+el );
	var file = elem[0].files[0];
	
	if(file === undefined){
		message("errorMajBase", "Veuillez sélectionner un fichier");
		return false;
	}else{
		uploadFile(el, target);
	}
}

// -------------------------------------------------------------------------------------------- CONTACT --------------------------------------------------------------------------------------------

function sendMail()
{
	console.log('sendMail()');
	message("errorMail", "");
	message("confirmMail", "");
	
	if($('#nom').val() == ""){
		message("errorMail", "Merci de saisir un Nom");
		return false;
	}
	
	if($('#email').val() == ""){
		message("errorMail", "Merci de saisir un Email");
		return false;
	}else if(!isEmail($('#email').val())){
		message("errorMail", "Merci de saisir un Email valide");
		return false;
	}
	
	var data={};
	data["send"] = 1;
	data["prenom"] = $('#prenom').val();
	data["nom"] = $('#nom').val();
	data["tel"] = $('#tel').val();
	data["email"] = $('#email').val();
	
	if($('.wrapperSupportMail').length){
		console.log('Support exists');
		data["support"] = 1;
		if($('#supportOs').val() == "none"){
			message("errorMail", "Merci de sélectionner votre système d'exploitation");
			return false;
		}
		if($('#supportBrowser').val() == "none"){
			message("errorMail", "Merci de sélectionner votre navigateur Internet");
			return false;
		}
		data["os"] = $('#supportOs').val();
		data["browser"] = $('#supportBrowser').val();
	}else{
		data["support"] = 0;
	}
	
	if($('#sujet').val() == ""){
		message("errorMail", "Merci de saisir un Sujet");
		return false;
	}
	
	if($('#content').val() == ""){
		message("errorMail", "Merci de saisir le message");
		return false;
	}
	
	data["sujet"] = $('#sujet').val();
	data["content"] = $('#content').val();
	
	$('#loaderContact').css("display", "block");
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/sendMail.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmMail", msg["content"]);
				$('#loaderContact').css("display", "none");
				$('#sujet').val('');
				$('#content').val('');
			}else{
				message("errorMail", msg["content"]);
				$('#loaderContact').css("display", "none");
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorMail", "Pas de connexion au serveur");
			$('#loaderContact').css("display", "none");
		}
	});
}

// -------------------------------------------------------------------------------------------- UPLOAD DE FICHIERS --------------------------------------------------------------------------------------------

// Upload de fichier
var Upload = function (file) {
    this.file = file;
};

Upload.prototype.getType = function() {
    return this.file.type;
};
Upload.prototype.getSize = function() {
    return this.file.size;
};
Upload.prototype.getName = function() {
    return this.file.name;
};
Upload.prototype.doUpload = function (el, target) {
    console.log("--- doUpload("+target+") ---");
	console.log(siteURL+'/control/recordFile.php');
	var elem = $("#"+el+"Link");
	var that = this;
    var formData = new FormData();

    $("#lineProgress").css('display', 'block');
	
	// add assoc key values, this will be posts values
    formData.append("file", this.file, this.getName());
    formData.append("upload_file", true);
	formData.append("sent", 1);
	formData.append("description", $("#docDesc").val());
	formData.append("cat", $("#listeCat").val());
	formData.append("target", target);

    $.ajax({
        type: "POST",
        url: siteURL+'/control/recordFile.php',
        xhr: function () {
            var myXhr = $.ajaxSettings.xhr();
            if (myXhr.upload) {
                myXhr.upload.addEventListener('progress', that.progressHandling, false);
            }
            return myXhr;
        },
        success: function (msg) {
            console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			
			if(msg["code"] != "OK"){
				message("errorAddFile", msg["content"]);
				$(".loader").css("display", "none");
				$("#progress-wrp").fadeToggle(500);
				message("errorMajBase", msg["content"]);
			}else{
				message("confirmAddFile", msg["content"]);
				if(target == 'docs'){
					$('#listeDoc,#listeDocEdit').find('option').remove().end();
					listDoc('#listeDoc');
					listDocById('#listeDocEdit');
				}else if(target == 'home'){
					$('#listeDochome').find('option').remove().end();
					$('#listeDochome,#listeDochome2').find('option').remove().end();
					listDocHomeById('#listeDochome');
					listDocHome('#listeDochome2');
				}else if(target == 'base'){
					$(".loader").css("display", "none");
					$("#progress-wrp").fadeToggle(500);
					message("confirmMajBase", msg["content"]);
				}				
			}
        },
        error: function (msg) {
            console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddFile", msg["content"]);
			console.log("ERROR: %o", msg);
        },
        async: true,
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        timeout: 180000
    });
};

Upload.prototype.progressHandling = function (event) {
    var percent = 0;
    var position = event.loaded || event.position;
    var total = event.total;
    var progress_bar_id = "#progress-wrp";
    if (event.lengthComputable) {
        percent = Math.ceil(position / total * 100);
    }
    // update progressbars classes so it fits your code
    $(progress_bar_id + " .progress-bar").css("width", +percent + "%");
    $(progress_bar_id + " .status").text(percent + "%");
};

function uploadFile(el, target)
{
	console.log("--- uploadFile("+target+") ---");
	var elem = $( "#"+el );
	var file = elem[0].files[0];
	//console.log(file);
    var upload = new Upload(file);

    // maby check size or type here with upload.getSize() and upload.getType()

    // execute upload
    upload.doUpload(el, target);
}

// ------------------------------------------------------------------ DOCUMENTS ------------------------------------------------------------------

function uploadDoc(el, target)
{
	console.log("--- uploadDoc("+el+", "+target+") ---");
	message("errorAddFile", "");
	message("confirmAddFile", "");
	
	var elem = $( "#"+el );
	var file = elem[0].files[0];
	
	if(file === undefined){
		message("errorAddFile", "Veuillez sélectionner un fichier");
		return false;
	}else if($('#listeCat').val()=='none'){
		message("errorAddFile", "Veuillez sélectionner une catégorie");
		return false;
	}else if($('#docDesc').val()==''){
		message("errorAddFile", "Veuillez saisir une description");
		return false;
	}else{
		uploadFile(el, target);
	}
}

function listDoc(el)
{
	console.log("--- listDoc("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDoc.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			elem.append('<option value="none"><b>--- Sélectionner ---</b></option>');
			for(var i=0; i< msg["content"].length; i++){
				elem.append('<option value="'+msg["content"][i][2]+'.'+msg["content"][i][4]+'"><b>'+msg["content"][i][3]+'</b></option>');
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});	
}

function listDocById(el)
{
	console.log("--- listDocById("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDoc.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			elem.append('<option value="none"><b>--- Sélectionner ---</b></option>');
			for(var i=0; i< msg["content"].length; i++){
				elem.append('<option value="'+msg["content"][i][0]+'"><b>'+msg["content"][i][3]+'</b></option>');
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});	
}

function listDocByCat(el,target,mode)
{
	console.log("--- listDocByCat("+el+","+target+") ---");
	var elem = $(el);
	var target = $(target);
	
	if(mode == "id"){
		$('#docDescEdit').val('');
	}
	
	var data={};
	data["catId"] = elem.val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocByCatId.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				// On vide la target
				target.find('option').remove().end();
				// On rempli la target
				target.append('<option value="none"><b>--- Sélectionner ---</b></option>');
				for(var i=0; i<msg["content"].length; i++){
					if(mode == "id"){
						target.append('<option value="'+msg["content"][i][0]+'"><b>'+msg["content"][i][3]+'</b></option>');
					}else{
						target.append('<option value="'+msg["content"][i][2]+'.'+msg["content"][i][4]+'"><b>'+msg["content"][i][3]+'</b></option>');
					}					
				}
			}else{
				// On vide la target
				target.find('option').remove().end();
				// On rempli la target
				target.append('<option value="none"><b>'+msg["content"]+'</b></option>');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
	
}

function loadDocDesc()
{
	console.log("--- loadDocDesc() ---");
	message("errorEditDoc", "");
	message("confirmEditDoc", "");
	
	if($('#listeDocEdit').val() == "none"){
		console.log("Reset Select");
		$('#docDescEdit').val('');
		return false;
	}else{
		var data={};
		data["docId"] = $('#listeDocEdit').val();
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocDesc.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			$('#docDescEdit').val(msg["content"][0][0]);
		},
		error: function(msg){
			message("errorEditDoc", "Pas de connexion au serveur");
		}
	});
}

function editDoc()
{
	console.log("--- editDoc() ---");
	message("errorEditDoc", "");
	message("confirmEditDoc", "");

	if($('#listeDocEdit').val() == "none"){
		message("errorEditDoc", "Veuillez sélectionner un document");
		return false;
	}else{
		var data={};
		data["docId"] = $('#listeDocEdit').val();
	}
	
	data["docDesc"] = $('#docDescEdit').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/editDocDesc.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditDoc", msg["content"]);
			}else{
				message("errorEditDoc", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorEditDoc", "Pas de connexion au serveur");
		}
	});
}

function supprDoc()
{
	console.log("--- supprDoc() ---");
	message("errorSupprDoc", "");
	message("confirmSupprDoc", "");
	
	if($('#listeDoc').val() == "none"){
		message("errorSupprDoc", "Veuillez sélectonnier un document à supprimer");
		return false;
	}
	
	var dial = $("#dialog");
	
	var myButtons = {
		"Oui": function () {
			var data={};
			data["docFile"] = $('#listeDoc').val();
			console.log("Fichier à supprimer : "+data["docFile"]);
			$.ajax({
				type: 'POST',
				url: siteURL+'/control/supprDoc.php',
				data: { 'data' : data },
				success: function(msg){
					console.log("Mess code : "+msg["code"]);
					console.log("Mess content : "+msg["content"]);
					if(msg["content"] == "OK"){
						message("confirmSupprDoc", "Fichier supprimé");
						$('#listeDoc').find('option').remove().end();
						if($('#listeCatSuppr').val() != "none"){
							listDocByCat('#listeCatSuppr','#listeDoc','file');
						}else{
							listDoc('#listeDoc');
						}
						
						dial.dialog("close");
					}
				},
				error: function(msg){
					console.log("ERROR MESSAGE : "+msg["content"]);
					message("errorSupprDoc", "Pas de connexion au serveur");
				}
			});
		},
		"Non": function () {
			dial.dialog("close");
		}
	};
	dial.dialog( "option", "height", "auto" );
	dial.dialog( "option", "width", "420px" );
	dial.dialog( "option", "title", "Confirmation" );
	dial.html("<center><b>Etes-vous sûr de vouloir supprimer le document "+$( "#listeDoc option:selected" ).text().trim()+" ?</b></center>");
	dial.dialog('option', 'buttons', myButtons);
	dial.dialog('option', 'position', 'center');
	dial.dialog( "open" );
}

function uploadDocHome(el, target)
{
	//uploadFile(el, target);
	console.log("--- uploadDocHome("+el+", "+target+") ---");
	message("errorAddFile", "");
	message("confirmAddFile", "");
	
	var elem = $( "#"+el );
	var file = elem[0].files[0];
	
	if(file === undefined){
		message("errorAddFile", "Veuillez sélectionner un fichier");
		return false;
	}else if($('#docDesc').val()==''){
		message("errorAddFile", "Veuillez saisir une description");
		return false;
	}else{
		uploadFile(el, target);
	}
}

function listDocHome(el)
{
	console.log("--- listDocHome("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocHome.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			elem.append('<option value="none"><b>--- Sélectionner ---</b></option>');
			for(var i=0; i< msg["content"].length; i++){
				elem.append('<option value="'+msg["content"][i][1]+'.'+msg["content"][i][3]+'"><b>'+msg["content"][i][2]+'</b></option>');
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});	
}

function listDocHomeById(el)
{
	console.log("--- listDocHomeById("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocHome.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			elem.append('<option value="none"><b>--- Sélectionner ---</b></option>');
			for(var i=0; i< msg["content"].length; i++){
				elem.append('<option value="'+msg["content"][i][0]+'"><b>'+msg["content"][i][2]+'</b></option>');
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});	
}

function supprDocHome()
{
	console.log("--- supprDocHome() ---");
	message("errorSupprDoc", "");
	message("confirmSupprDoc", "");
	
	if($("#listeDochome2").val() == "none"){
		message("errorSupprDoc", "Veuillez sélectionner un document");
		return false;
	}
	
	var dial = $("#dialog");	
	var myButtons = {
		"Oui": function () {
			var data={};
			data["docFile"] = $('#listeDochome2').val();
			console.log("Fichier à supprimer : "+data["docFile"]);
			$.ajax({
				type: 'POST',
				url: siteURL+'/control/supprDocHome.php',
				data: { 'data' : data },
				success: function(msg){
					console.log("Mess code : "+msg["code"]);
					console.log("Mess content : "+msg["content"]);
					if(msg["code"] == "ok"){
						message("confirmSupprDoc", "Fichier supprimé");
						$('#listeDochome,#listeDochome2').find('option').remove().end();
						listDocHomeById('#listeDochome');
						listDocHome('#listeDochome2');
						dial.dialog("close");
					}else{
						message("errorSupprDoc", msg["content"]);
					}
				},
				error: function(msg){
					console.log("ERROR MESSAGE : "+msg["content"]);
					message("errorSupprDoc", "Pas de connexion au serveur");
				}
			});
		},
		"Non": function () {
			dial.dialog("close");
		}
	};
	dial.dialog( "option", "height", "auto" );
	dial.dialog( "option", "width", "420px" );
	dial.dialog( "option", "title", "Confirmation" );
	dial.html("<center><b>Etes-vous sûr de vouloir supprimer le document "+$( "#listeDochome2 option:selected" ).text().trim()+" ?</b></center>");
	dial.dialog('option', 'buttons', myButtons);
	dial.dialog('option', 'position', 'center');
	dial.dialog( "open" );
}

function loadDocHomeDesc()
{
	console.log("--- loadDocHomeDesc() ---");
	message("errorEditDoc", "");
	message("confirmEditDoc", "");
	
	if($('#listeDochome').val() == "none"){
		console.log("Reset Select");
		$('#docEditDesc').val('');
		return false;
	}else{
		var data={};
		data["docHomeId"] = $('#listeDochome').val();
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocHomeDesc.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			$('#docEditDesc').val(msg["content"][0][0]);
		},
		error: function(msg){
			message("errorEditDoc", "Pas de connexion au serveur");
		}
	});
}

function editDocHome()
{
	console.log("--- editDocHome() ---");
	message("errorEditDoc", "");
	message("confirmEditDoc", "");

	if($('#listeDochome').val() == "none"){
		message("errorEditDoc", "Veuillez sélectionner un document");
		return false;
	}else{
		var data={};
		data["docHomeId"] = $('#listeDochome').val();
	}
	
	data["docHomeDesc"] = $('#docEditDesc').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/editDocHomeDesc.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "Modifications effectuées"){
					message("confirmEditDoc", msg["content"]);
				}else{
					message("errorEditDoc", msg["content"]);
				}
			}
		},
		error: function(msg){
			console.log("Url : "+siteURL+'/control/editDocHomeDesc.php');
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorEditDoc", "Pas de connexion au serveur");
		}
	});
}

// ------------------------------------------------------------------ CATEGORIES ------------------------------------------------------------------

// Chargement des catégories dans un ou des élement(s) el
function listCat(el)
{
	console.log("--- listCat("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getCat.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			var buffer = "";
			elem.append('<option value="none" style="color:#990000"><b>--- Sélectionner ---</b></option>');
			for(var i=0; i< msg["content"].length; i++){
				if(msg["content"][i][1] != buffer){
					elem.append('<option value="'+msg["content"][i][0]+'" style="color:#990000"><b>'+msg["content"][i][1]+'</b></option>');
					buffer = msg["content"][i][1];
				}
				if(msg["content"][i][2] != null){
					elem.append('<option value="'+msg["content"][i][2]+'" style="color:#799247">&nbsp;&nbsp;&nbsp;&nbsp;'+msg["content"][i][3]+'</option>');
				}
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});
}

function loadCat()
{
	console.log("--- loadCat() ---");
	message("errorEditCat", "");
	
	if($('#listeCat2').val() == "none"){
		console.log("Reset Select");
		$('#catNameEdit').val('');
		return false;
	}else{
		var data={};
		data["catId"] = $('#listeCat2').val();
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getCatById.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				$('#catNameEdit').val(msg["content"]);
			}else{
				message("errorEditCat", msg["content"]);
			}
		},
		error: function(msg){
			message("errorEditCat", "Pas de connexion au serveur");
		}
	});
}

function addCat()
{
	console.log("--- addCat() ---");
	message("errorAddCat", "");
	message("confirmAddCat", "");
	
	if($('#catName').val() == ""){
		message("errorAddCat", "Merci de saisir une catégorie");
		return false;
	}
	
	var data={};
	data["addCat"] = $('#catName').val().toUpperCase();
	
	if($('#sousCat').prop('checked')){
		console.log("checké "+$('#listeCat').val());
		data["parentCat"] = $('#listeCat').val();
	}else{
		data["parentCat"] = "none";
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addCat.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "OK"){
					message("confirmAddCat", "Catégorie ajoutée");
					$('#catName').val("");
					$('#listeCat,#listeCat2,#listeCat3').find('option').remove().end();
					listCat('#listeCat,#listeCat2,#listeCat3');
				}
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddCat", "Pas de connexion au serveur");
		}
	});
}

function editCat()
{
	console.log("--- editCat() ---");
	message("errorEditCat", "");
	message("confirmEditCat", "");
	
	
	if($('#catNameEdit').val() == ""){
		message("errorEditCat", "Merci de saisir un nouveau nom de catégorie");
		return false;
	}
	
	var data={};
	data["newCat"] = $('#catNameEdit').val().toUpperCase();
	data["catId"] = $('#listeCat2').val();
		
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/editCat.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "OK"){
					message("confirmEditCat", "Catégorie modifiée");
					$('#catNameEdit').val("");
					$('#listeCat,#listeCat2,#listeCat3').find('option').remove().end();
					listCat('#listeCat,#listeCat2,#listeCat3');
				}
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorEditCat", "Pas de connexion au serveur");
		}
	});	
}

function supprCat()
{
	console.log("--- supprCat() ---");
	message("errorSupprCat", "");
	message("confirmSupprCat", "");
	
	var dial = $("#dialog");
	
	var myButtons = {
		"Oui": function () {
			var data={};
			data["catId"] = $('#listeCat3').val();
			$.ajax({
				type: 'POST',
				url: siteURL+'/control/supprCat.php',
				data: { 'data' : data },
				success: function(msg){
					console.log("Mess code : "+msg["code"]);
					console.log("Mess content : "+msg["content"]);
					if(msg["content"] == "OK"){
						message("confirmSupprCat", "Catégorie supprimée");
						$('#listeCat,#listeCat2,#listeCat3').find('option').remove().end();
						listCat('#listeCat,#listeCat2,#listeCat3');
						dial.dialog("close");
					}
				},
				error: function(msg){
					console.log("ERROR MESSAGE : "+msg["content"]);
					message("errorSupprCat", "Pas de connexion au serveur");
				}
			});
		},
		"Non": function () {
			dial.dialog("close");
		}
	};
	dial.dialog( "option", "height", "auto" );
	dial.dialog( "option", "width", "420px" );
	dial.dialog( "option", "title", "Confirmation" );
	dial.html("<center><b>Etes-vous sûr de vouloir supprimer la categorie "+$( "#listeCat3 option:selected" ).text().trim()+" ?<br/>Tous les documents et sous-catégories associés seront également supprimés</b></center>");
	dial.dialog('option', 'buttons', myButtons);
	dial.dialog('option', 'position', 'center');
	dial.dialog( "open" );
}

// ------------------------------------------------------------------ INFOS HOME ------------------------------------------------------------------

function listInfo(el)
{
	console.log("--- listInfo("+el+") ---");
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getInfoHome.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			elem.append('<option value="none" style="">-- Sélectionner --</option>');
			for(var i=0; i< msg["content"].length; i++){
				elem.append('<option value="'+msg["content"][i][0]+'" style="">'+msg["content"][i][1]+'</option>');
			}
		},
		error: function(msg){
			console.log("ERROR : "+msg["code"]);
			console.log("ERROR: %o", msg);
		}
	});
}

function loadInfo()
{
	console.log("--- loadInfo() ---");
	message("errorEditInfo", "");
	message("confirmEditInfo", "");
	
	if($('#listeInfo').val() == "none"){
		console.log("Reset Select");
		$('#infoEditTitle').val('');
		$('#infoEditText').val('');
		$('#enableEditFile').prop('checked', false);
		$('#listeDochome2').find('option:eq(0)').prop('selected', true);
		return false;
	}else{
		var data={};
		data["infoId"] = $('#listeInfo').val();
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getInfoHomeById.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			$('#infoEditTitle').val(msg["content"][0][2]);
			$('#infoEditText').val(msg["content"][0][3]);
			if(msg["content"][0][1] != -1){
				$('#enableEditFile').prop('checked', true);
				$('#listeDochome2').val(msg["content"][0][1]);
			}else{
				$('#enableEditFile').prop('checked', false);
				$('#listeDochome2').find('option:eq(0)').prop('selected', true);
			}
		},
		error: function(msg){
			message("errorEditInfo", "Pas de connexion au serveur");
		}
	});	
}

function addInfo()
{
	console.log("--- addInfo() ---");
	message("errorAddInfo", "");
	message("confirmAddInfo", "");
	
	// Check remplissage ----------------------------------
	if($('#infoTitle').val() == ""){
		message("errorAddInfo", "Merci de saisir un titre");
		return false;
	}
	// Datas ---------------------------------------------
	var data={};
	data["sent"] = "1";
	data["infoTitle"] = $('#infoTitle').val().trim();
	data["infoText"] = $('#infoText').val().trim();
	
	if($('#enableFile').prop('checked')){
		console.log("enableFile checké");
		data["infoFile"] = $('#listeDochome').val();
	}else{
		data["infoFile"] = "none";
	}
	// Record ----------------------------------------------------------------------------
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addInfo.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmAddInfo", msg["content"]);
				$('#infoTitle').val("");
				$('#infoText').val("");
				$('#enableFile').prop('checked', false);
				$('#listeInfo,#listeInfo2').find('option').remove().end();
				listInfo('#listeInfo, #listeInfo2');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddInfo", "Pas de connexion au serveur");
		}
	});
}

function editInfo()
{
	console.log("--- editInfo() ---");
	message("errorEditInfo", "");
	message("confirmEditInfo", "");
	
	// Check Select
	if($("#listeInfo").val() == "none"){
		message("errorEditInfo", "Merci de sélectionner une info");
		return false;
	}
	// Check Remplissage
	if($('#infoEditTitle').val() == ""){
		message("errorEditInfo", "Merci de saisir un titre");
		return false;
	}
	// Datas ---------------------------------------------
	var data={};
	data["sent"] = "1";
	data["infoId"] = $("#listeInfo").val();
	data["infoTitle"] = $('#infoEditTitle').val().trim();
	data["infoText"] = $('#infoEditText').val().trim();
	
	if($('#enableEditFile').prop('checked')){
		console.log("enableEditFile checké");
		data["infoFile"] = $('#listeDochome2').val();
	}else{
		data["infoFile"] = "none";
	}
	// Update ----------------------------------------------------------------------------
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/editInfo.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditInfo", msg["content"]);
				$('#infoEditTitle').val("");
				$('#infoEditText').val("");
				$('#enableEditFile').prop('checked', false);
				$('#listeInfo,#listeInfo2').find('option').remove().end();
				listInfo('#listeInfo, #listeInfo2');
				$('#listeDochome2').find('option:eq(0)').prop('selected', true);
			}else{
				message("errorEditInfo", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorEditInfo", "Pas de connexion au serveur");
		}
	});
}

function supprInfo()
{
	console.log("--- supprInfo() ---");
	message("errorSupprInfo", "");
	message("confirmSupprInfo", "");
	
	// Check Select
	if($("#listeInfo2").val() == "none"){
		message("errorSupprInfo", "Merci de sélectionner une info");
		return false;
	}
	
	var dial = $("#dialog");
	
	var myButtons = {
		"Oui": function () {
			var data={};
			data["infoId"] = $('#listeInfo2').val();
			$.ajax({
				type: 'POST',
				url: siteURL+'/control/supprInfo.php',
				data: { 'data' : data },
				success: function(msg){
					console.log("Mess code : "+msg["code"]);
					console.log("Mess content : "+msg["content"]);
					if(msg["code"] == "ok"){
						message("confirmSupprInfo", msg["content"]);
						$('#listeInfo,#listeInfo2').find('option').remove().end();
						listInfo('#listeInfo, #listeInfo2');
						dial.dialog("close");
					}else{
						message("errorSupprInfo", msg["content"]);
					}
				},
				error: function(msg){
					console.log("ERROR MESSAGE : "+msg["content"]);
					message("errorSupprInfo", "Pas de connexion au serveur");
				}
			});
		},
		"Non": function () {
			dial.dialog("close");
		}
	};
	dial.dialog( "option", "height", "auto" );
	dial.dialog( "option", "width", "420px" );
	dial.dialog( "option", "title", "Confirmation" );
	dial.html("<center><b>Etes-vous sûr de vouloir supprimer l'info "+$( "#listeInfo2 option:selected" ).text().trim()+" ?</b></center>");
	dial.dialog('option', 'buttons', myButtons);
	dial.dialog('option', 'position', 'center');
	dial.dialog( "open" );
}

// -------------------------------------------------------------------------------------------- HOME --------------------------------------------------------------------------------------------

function loadHomeInfo(infoId)
{
	console.log("--- loadHomeInfo("+infoId+") ---");
	
	if(infoId === undefined){
		console.log("Chargement des 3 dernières news");
		infoId = "home";
	}
	
	$("#loaderHome").css("display", "block");
	
	var data={};
	data["infoId"] = infoId;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getInfoHomeFull.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				$("#loaderHome").css("display", "none");
				$('#wrapperElemHome').empty();
				for(var i=0; i<msg["content"].length; i++){
					var elem = '<div class="elemHome">';
					elem += '<div class="homeTitle">'+msg["content"][i][2]+'</div>';
					elem += '<div class="homeContent">'+nl2br(msg["content"][i][3], false)+'</div>';
					if(msg["content"][i][5] != null){
						console.log("Document trouvé");
						var filePath = siteURL+"/docsHome/"+msg["content"][i][6]+"."+msg["content"][i][8];
						elem += '<div class="homeFile" onClick="window.open(\''+filePath+'\');"><div class="icone"><img src="images/icons/'+getFileIcon(msg["content"][i][8])+'"></div><div class="desc">'+msg["content"][i][9]+'</div></div>';
					}
					elem += '</div>';
					if(i != msg["content"].length-1){
						elem += '<hr>';
					}
					$('#wrapperElemHome').append(elem);
				}
			}else{
				$("#loaderHome").css("display", "none");
				console.log("Mess content : "+msg["content"]);
			}
		},
		error: function(msg){
			$("#loaderHome").css("display", "none");
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
}

function loadHomeActuNav(page)
{
	console.log("--- loadHomeActuNav("+page+") ---");
	
	$("#loaderHome2").css("display", "block");
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getInfoHomeCount.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				$("#loaderHome2").css("display", "none");
				$('#wrapperActuHomeNav').empty();
				var nbInfos = msg["content"][0][0];
				var nbPages = Math.ceil(nbInfos/10);
				if(nbPages > 5){
					if(page > 3){
						var pageStart = page-3;
					}else{
						var pageStart = 1;
					}			
					if(page < nbPages-3){
						var pageEnd = page+3;
					}else{
						var pageEnd = nbPages;
					}
				}else{
					var pageStart = 1;
					var pageEnd = nbPages;
				}
				$('#wrapperActuHomeNav').append("<div class='elemActuNav debut' onClick='loadHomeActu(1);'>Début</div> - ");
				$('#wrapperActuHomeNav').append("<div class='elemActuNav' onClick='loadHomeActu("+(page-1)+");'><b><</b></div> - ");
				for(var i=pageStart; i <= pageEnd; i++){
					if(i == page){
						var actif = " current";
					}else{
						var actif = "";
					}
					$('#wrapperActuHomeNav').append("<div class='elemActuNav"+actif+"' onClick='loadHomeActu("+i+");'>"+i+"</div> - ");
				}
				$('#wrapperActuHomeNav').append("<div class='elemActuNav' onClick='loadHomeActu("+(page+1)+");'><b>></b></div>");
				$('#wrapperActuHomeNav').append(" - <div class='elemActuNav fin' onClick='loadHomeActu("+nbPages+");'>Fin</div>");
			}else{
				$("#loaderHome2").css("display", "none");
				console.log("Mess content : "+msg["content"]);
			}
		},
		error: function(msg){
			$("#loaderHome2").css("display", "none");
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
	
}

function loadHomeActu(page)
{
	console.log("--- loadHomeActu("+page+") ---");
	
	if(page === undefined){
		console.log("Erreur lors du chargement des actus");
		return false;
	}
	
	$("#loaderHome2").css("display", "block");
	
	var data={};
	data["page"] = page;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getInfoHomeTitle.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				$("#loaderHome2").css("display", "none");
				$('#wrapperElemActuHome').empty();
				for(var i=0; i<msg["content"].length; i++){
					var elem = '<div class="elemActuHome" onClick="loadHomeInfo('+msg["content"][i][0]+');">'+msg["content"][i][1]+'</div><hr>';
					$('#wrapperElemActuHome').append(elem);
				}
				loadHomeActuNav(page);
			}else{
				$("#loaderHome2").css("display", "none");
				console.log("Mess content : "+msg["content"]);
			}
		},
		error: function(msg){
			$("#loaderHome2").css("display", "none");
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});	
}

// -------------------------------------------------------------------------------------------- DOCUMENTATION --------------------------------------------------------------------------------------------

function loadDocuments(catId)
{
	console.log("--- loadDocuments("+catId+") ---");
	$("#loader").css("display", "block");
	$("#textAccueil").css("display", "none");
	$("#textAccueil").html("Utilisez le menu afin de choisir la catégorie de documents qui vous intéresse.");
	$("#elemWrapper").empty();
	
	var data={};
	data["catId"] = catId;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDocByCatId.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				$("#loader").css("display", "none");
				for(var i=0; i<msg["content"].length; i++){
					var filePath = siteURL+"/docs/"+msg["content"][i][2]+"."+msg["content"][i][4];
					$("#elemWrapper").append('<div class="docElement" onClick="window.open(\''+filePath+'\');"><div class="icone"><img src="images/icons/'+getFileIcon(msg["content"][i][4])+'"></div><div class="desc">'+msg["content"][i][5]+'</div></div>');
				}
			}else{
				$("#loader").css("display", "none");
				$("#textAccueil").html(msg["content"]);
				$("#textAccueil").css("display", "block");
			}
		},
		error: function(msg){
			$("#loader").css("display", "none");
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- MODULES --------------------------------------------------------------------------------------------

function checkDateModule(mode,table,dateText, elem)
{
	console.log("--- checkDateModule('"+mode+"','"+table+"','"+dateText+"','"+elem+"') ---");
	message("errorModGen", "");
	
	var elem = $(elem);
	
	var jour = dateText.split(',');
	jour = jour[0];
	console.log("jour : "+jour);
	
	if(table == "palais"){
		if(mode == 'start'){
			if(jour != 'mardi' && jour != 'jeudi' && jour != 'samedi'){
				message("errorModGen", "Veuillez choisir un jour correspondant à un début de module");
				elem.val('');
				return false;			
			}
		}else{
			if(jour != 'mercredi' && jour != 'vendredi' && jour != 'lundi'){
				message("errorModGen", "Veuillez choisir un jour correspondant à une fin de module");
				elem.val('');
				return false;			
			}
		}
	}else{
		if(mode == 'start'){
			if(jour != 'lundi' && jour != 'mercredi' && jour != 'vendredi'){
				message("errorModGen", "Veuillez choisir un jour correspondant à un début de module");
				elem.val('');
				return false;			
			}
		}else{
			if(jour != 'mardi' && jour != 'jeudi' && jour != 'dimanche'){
				message("errorModGen", "Veuillez choisir un jour correspondant à une fin de module");
				elem.val('');
				return false;			
			}
		}
		
	}
}

function genModules(mode)
{
	console.log("--- genModules('"+mode+"') ---");
	message("errorModGen", "");
	message("confirmModGen", "");
	
	console.log("Caché Debut : "+$('#dateHidden').val());
	console.log("Caché Fin : "+$('#dateHidden2').val());
	
	// Test mois et année de création
	var monthYear = $('#lastMonthYear').val().split(',');
	for(var i = 0; i< monthYear.length; i++){
		console.log(monthYear[i]);
		if($('#mois').val().toString()+"-"+$('#annee').val().toString() == monthYear[i]){
			message("errorModGen", "Vous avez déjà généré les modules pour "+returnLitteralMonth($('#mois').val())+" "+$('#annee').val().toString());
			return false;
		}
	}
	
	// Remplissage
	if($('#dateHidden').val() == ""){
		message("errorModGen", "Merci de sélectionner une date de début");
		return false;
	}
	if($('#dateHidden2').val() == ""){
		message("errorModGen", "Merci de sélectionner une date de fin");
		return false;
	}
	// Cohérence
	var dateStart = new Date($('#dateHidden').val());
	var dateEnd = new Date($('#dateHidden2').val());
	if(dateStart >= dateEnd){
		message("errorModGen", "La date de début doit être inférieure à la date de fin");
		return false;
	}
		
	var data={};
	data["mode"] = mode;
	data["dateStart"] = $('#dateHidden').val();
	data["dateEnd"] = $('#dateHidden2').val();
	data["mois"] = $('#mois').val();
	data["annee"] = $('#annee').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/genModules.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmModGen", msg["content"]);
				getLastModule('#lastModule', mode);
				getModules('#listModules', mode, 10);
				$("#datepicker,#datepicker2").val('');
			}else{
				message("errorModGen", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function deleteModules(mode)
{
	console.log("--- deleteModules('"+mode+"') ---");
	message("errorDeleteModule", "");
	message("confirmDeleteModule", "");
	
	if($('#listModules').val() == "none"){
		message("errorDeleteModule", "Veuillez choisir une période");
		return false;
	}else{
		var donnees = $('#listModules').val().split("-");
		var annee = donnees[0];
		var mois = donnees[1];
		console.log(annee);
		console.log(mois);
	}
	
	var data={};
	data["sent"] = 1;
	data["mode"] = mode;
	data["annee"] = annee;
	data["mois"] = mois;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deleteModules.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				message("confirmDeleteModule", msg["content"]);
				getModules('#listModules', mode, 10);
			}else{
				message("errorDeleteModule", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE deleteModules : "+msg["content"]);
			message("errorDeleteModule", msg["content"]);
		}
	});
}

function getModules(elem, mode, nb)
{
	console.log("--- getModules('"+elem+"', '"+mode+"', "+nb+") ---");
	message("errorDeleteModule", "");
	
	var elem = $(elem);
	
	elem.find('option').remove().end();
	
	var data={};
	data["sent"] = 1;
	data["nombre"] = nb;
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getModules.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '<option value="none">--- Choisir ---</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += '<option value="'+msg["content"][i]["mod_annee"]+'-'+msg["content"][i]["mod_mois"]+'">'+msg["content"][i][2]+' '+msg["content"][i]["mod_annee"]+'</option>';
				}
				elem.append(html);
			}else{
				message("errorDeleteModule", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE getModules : "+msg["content"]);
			message("errorDeleteModule", msg["content"]);
		}
	});
}

function getLastModule(elem, mode)
{
	console.log("--- getLastModule('"+mode+"') ---");
	message("errorModGen", "");
	
	var elemHidden = $(elem+"Hidden");
	var elem = $(elem);
	
	var data={};
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getLastModule.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				var retour = msg["content"][1]+" "+msg["content"][0][1];
				elem.html("Dernier modules créés : <b>"+retour+"</b>");
				elemHidden.val(msg["content"][0][0]+"/"+msg["content"][0][1]);
				var dernierMois = msg["content"][0][0];
				var derniereAnnee = msg["content"][0][1];
				if(++dernierMois > 12){
					dernierMois = (dernierMois%12);
				}				
				if(dernierMois == 1){
					derniereAnnee++;
				}
				$('#mois option[value="'+dernierMois+'"]').prop('selected', true);
				$('#annee option[value="'+derniereAnnee+'"]').prop('selected', true);
				$( "#datepicker,#datepicker2" ).datepicker( "option", "defaultDate", new Date(derniereAnnee, --dernierMois, 1) );

			}else{
				message("errorModGen", msg["content"]);
			}
			return retour;
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorModGen", msg["content"]);
		}
	});
}

function genSelectModule(elem)
{
	console.log("--- genSelectModule('"+elem+"') ---");
	message("errorModGen", "");
	message("confirmModGen", "");
	
	console.log("Last Module : "+$('#lastModuleHidden').val());
		
	var elem = $(elem);
	var date = new Date();
	var currentMonth = date.getMonth()+1;
	var currentYear = date.getFullYear();
	
	for(var i=1; i < 13; i++){
		if(i == currentMonth){
			var selected = " selected";
		}else{
			var selected = "";
		}		
		elem.append('<option value="'+i+"/"+currentYear+'"'+selected+'>'+returnLitteralMonth(i)+" "+currentYear+'</b></option>');
	}
}

function genSelectModuleMonth(elem)
{
	console.log("--- genSelectModuleMonth('"+elem+"') ---");
	message("errorModGen", "");
	message("confirmModGen", "");
	
	var elem = $(elem);
	var date = new Date();
	var currentMonth = date.getMonth()+1;
	
	for(var i=1; i < 13; i++){
		if(i == currentMonth){
			var selected = " selected";
		}else{
			var selected = "";
		}		
		elem.append('<option value="'+i+'"'+selected+'>'+returnLitteralMonth(i)+'</b></option>');
	}
}

function genSelectModuleYear(elem)
{
	console.log("--- genSelectModuleYear('"+elem+"') ---");
	message("errorModGen", "");
	message("confirmModGen", "");
	
	var elem = $(elem);
	var date = new Date();
	var currentYear = date.getFullYear();
	
	for(var i=2019; i < 2051; i++){
		if(i == currentYear){
			var selected = " selected";
		}else{
			var selected = "";
		}		
		elem.append('<option value="'+i+'"'+selected+'>'+i+'</b></option>');
	}	
}

// -------------------------------------------------------------------------------------------- USERS --------------------------------------------------------------------------------------------

function loadLoginList(el)
{
	console.log("--- loadLoginList('"+el+"') ---");
	message("errorLoginList", "");
	message("confirmLoginList", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	elem.html('');
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getLoginList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '';
				for(var i=0; i < msg["content"].length; i++){
					html += msg["content"][i]["user_login"]+'|';
				}
				elem.append(html.slice(0,-1));
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function loadCodeList(el)
{
	console.log("--- loadCodeList('"+el+"') ---");
	message("errorLoginList", "");
	message("confirmLoginList", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	elem.html('');
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getCodeList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '';
				for(var i=0; i < msg["content"].length; i++){
					html += msg["content"][i]["user_code"]+'|';
				}
				elem.append(html.slice(0,-1));
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function loadUserList(el, mode, valeur)
{
	console.log("--- loadUserList('"+el+","+mode+","+valeur+"') ---");
	message("errorLoginList", "");
	message("confirmLoginList", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	elem.find('option').remove().end();
	
	var data={};
	data["mode"] = mode;
	data["valeur"] = valeur;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getUserList.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '<option value="tous">--- TOUS ---</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += '<option value="'+msg["content"][i]["user_id"]+'">'+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+' ('+msg["content"][i]["user_code"]+')</option>';
				}
				elem.append(html);
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function loadUserDetail(el, mode, valeur)
{
	console.log("--- loadUserDetail('"+el+"','"+mode+"','"+valeur+"') ---");
	message("errorFetchUser", "");
	message("confirmLoginList", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	var data={};
	data["mode"] = mode;
	data["valeur"] = valeur;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getUserList.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				elem.html('');
				var html = '';
				for(var i=0; i < msg["content"].length; i++){
					html += '<div class="userListElem" id="elem_'+msg["content"][i]["user_id"]+'">';
					html += '<div class="userListElemTop">';
					html += '<div style="display: flex; flex-grow: 5;">';
					html += '<div><b>'+msg["content"][i]["user_code"]+'</b></div>';
					html += '<div><b>'+msg["content"][i]["user_prenom"]+' '+msg["content"][i]["user_nom"]+'</b></div>';
					html += '<div>'+msg["content"][i]["user_email"]+'</div>';
					html += '<div>'+msg["content"][i]["user_tel3"]+'</div>';
					html += '</div><div style="display: flex;">';
					html += '<div><button type="button" id="editButton_'+msg["content"][i]["user_id"]+'" onclick="$(\'#userAddWrapper_'+msg["content"][i]["user_id"]+'\').fadeToggle(500); $(\'#editButton_'+msg["content"][i]["user_id"]+'\').html($(\'#editButton_'+msg["content"][i]["user_id"]+'\').html() == \'Modifier\' ? \'Fermer\' : \'Modifier\');">Modifier</button></div>';
					//html += '<div><button type="button" onclick="deleteUser('+msg["content"][i]["user_id"]+');">Supprimer</button></div>';
					html += '</div></div>';
					html += '<div class="errorMessage" id="errorDeleteUser_'+msg["content"][i]["user_id"]+'"></div>';
					html += '<div class="confirmMessage" id="confirmDeleteUser_'+msg["content"][i]["user_id"]+'"></div>';
					html += '<div class="userAddWrapper" id="userAddWrapper_'+msg["content"][i]["user_id"]+'" style="display:none;">';
					html += '<div class="ligneContent"><span class="sstitre"><b>Modifier</b></span></div>';
					if(msg["content"][i]["user_actif"] == 1){
						var actif = "selected";
						var inactif = "";
					}else{
						var actif = "";
						var inactif = "selected";
					}
					html += '<div class="ligneContent">Statut : <select id="actif_'+msg["content"][i]["user_id"]+'"><option value="1" '+actif+'>Actif</option><option value="0" '+inactif+'>Inactif</option></select></div>';
					html += '<div class="ligneContent">Code* : <input type="text" id="code_'+msg["content"][i]["user_id"]+'" placeholder="Code Avocat* (0 si non avocat)" value="'+msg["content"][i]["user_code"]+'"><input type="hidden" id="code_buff_'+msg["content"][i]["user_id"]+'" value="'+msg["content"][i]["user_code"]+'"></div>';
					html += '<div class="ligneContent">Login* : <input type="text" id="login_'+msg["content"][i]["user_id"]+'" placeholder="Login*"  value="'+msg["content"][i]["user_login"]+'"><input type="hidden" id="login_buff_'+msg["content"][i]["user_id"]+'" value="'+msg["content"][i]["user_login"]+'"></div>';
					html += '<div class="ligneContent">Password* : <input type="text" id="password_'+msg["content"][i]["user_id"]+'" placeholder="Laisser vide = pas de changement"></div>';
					html += '<div class="ligneContent">Prénom* : <input type="text" id="prenom_'+msg["content"][i]["user_id"]+'" placeholder="Prénom*" value="'+msg["content"][i]["user_prenom"]+'"></div>';
					html += '<div class="ligneContent">Nom* : <input type="text" id="nom_'+msg["content"][i]["user_id"]+'" placeholder="Nom*" value="'+msg["content"][i]["user_nom"]+'"></div>';
					html += '<div class="ligneContent">Email* : <input type="text" id="email_'+msg["content"][i]["user_id"]+'" placeholder="Email*" value="'+msg["content"][i]["user_email"]+'"></div>';
					html += '<div class="ligneContent">Email Perso : <input type="text" id="emailPerso_'+msg["content"][i]["user_id"]+'" placeholder="Email Perso" value="'+msg["content"][i]["user_email_perso"]+'"></div>';
					html += '<div class="ligneContent">Tel Portable* : <input type="text" id="tel3_'+msg["content"][i]["user_id"]+'" placeholder="Téléphone (portable)*" value="'+msg["content"][i]["user_tel3"]+'"></div>';
					html += '<div class="ligneContent">Tel Fixe : <input type="text" id="tel1_'+msg["content"][i]["user_id"]+'" placeholder="Téléphone (fixe)" value="'+msg["content"][i]["user_tel1"]+'"></div>';
					html += '<div class="ligneContent">Tel : <input type="text" id="tel2_'+msg["content"][i]["user_id"]+'" placeholder="Téléphone" value="'+msg["content"][i]["user_tel2"]+'"></div>';
					html += '<div class="ligneContent">Tel : <input type="text" id="tel4_'+msg["content"][i]["user_id"]+'" placeholder="Téléphone" value="'+msg["content"][i]["user_tel4"]+'"></div>';
					html += '<div class="ligneContent"><div style="display: inline-block; white-space: nowrap;"><label style="font-weight:normal; margin-bottom: 0px;" for="sendMail">Envoyer email : <input type="checkbox" style="width: unset;" id="sendMail"></label></div></div>';
					html += '<div class="ligneContent">* Champs obligatoires</div>';
					html += '<div class="ligneContent" style="text-align: center;"><button type="button" onClick="editUser('+msg["content"][i]["user_id"]+');">Valider</button></div>';
					html += '<div class="ligneContent" style="text-align: center;"><div class="errorMessage" id="errorEditUser_'+msg["content"][i]["user_id"]+'"></div></div>';
					html += '<div class="ligneContent" style="text-align: center;"><div class="confirmMessage" id="confirmEditUser_'+msg["content"][i]["user_id"]+'"></div></div>';
					html += '<div id="loader" class="loader"><img src="images/ajax_loader.gif"></div>';
					html += '</div>';
					html += '</div>';
				}
				elem.append(html);
				$("#loader").css("display", "none");
			}else{
				message("errorFetchUser", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorFetchUser", msg["content"]);
		}
	});
}

function deleteUser(userId)
{
	console.log("--- deleteUser("+userId+") ---");
	message("errorDeleteUser_"+userId, "");
	message("confirmDeleteUser_"+userId, "");
	
	var dial = $("#dialog");
	
	var myButtons = {
		"Oui": function () {
			var data={};
			data["userId"] = userId;
			$.ajax({
				type: 'POST',
				url: siteURL+'/control/deleteUser.php',
				data: { 'data' : data },
				success: function(msg){
					console.log("Mess code : "+msg["code"]);
					console.log("Mess content : "+msg["content"]);
					if(msg["code"] == "ok"){
						message("confirmDeleteUser_"+userId, msg["content"]);
						dial.dialog("close");
						$('#elem_'+userId).fadeToggle(500);
						loadUserList('#userList', 'tous', 'tous');
					}else{
						message("errorDeleteUser_"+userId, msg["content"]);
					}
				},
				error: function(msg){
					console.log("ERROR MESSAGE : "+msg["content"]);
					message("errorDeleteUser_"+userId, "Pas de connexion au serveur");
				}
			});
		},
		"Non": function () {
			dial.dialog("close");
		}
	};
	dial.dialog( "option", "height", "auto" );
	dial.dialog( "option", "width", "420px" );
	dial.dialog( "option", "title", "Confirmation" );
	dial.html("<center><b>Etes-vous sûr de vouloir supprimer l'utilisateur "+$("#prenom_"+userId).val()+" "+$("#nom_"+userId).val()+"?</b></center>");
	dial.dialog('option', 'buttons', myButtons);
	dial.dialog('option', 'position', 'center');
	dial.dialog( "open" );
}

function editUser(uId)
{
	console.log("--- editUser("+uId+") ---");
	message("errorEditUser_"+uId, "");
	message("confirmEditUser_"+uId, "");
	
	//$("#loader").css("display", "block");	
	// On récupère la liste de login
	var loginList = $('#loginList').html();
	console.log("loginList : "+loginList);
	loginList = loginList.split('|');
	
	// On récupère la liste de codes
	var codeList = $('#codeList').html();
	console.log("codeList : "+codeList);
	codeList = codeList.split('|');
	
	//On bufferize le log et code actuels.
	var code = $('#code_buff_'+uId).val();
	var log = $('#login_buff_'+uId).val();
	
	// Remplissage
	if($('#code_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un code");
		return false;
	}
	if($.inArray($('#code_'+uId).val(),codeList) >=0 && $('#code_'+uId).val()!=0 && $('#code_'+uId).val() != code){
		message("errorEditUser_"+uId, "Ce code existe déjà");
		return false;
	}
	
	if($('#prenom_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un prénom");
		return false;
	}
	if($('#nom_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un nom");
		return false;
	}
	if($('#email_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un email");
		return false;
	}
	if(!isEmail($('#email_'+uId).val())){
		message("errorEditUser_"+uId, "Merci de saisir un email valide");
		return false;
	}
	if($('#emailPerso_'+uId).val() != "" && !isEmail($('#emailPerso_'+uId).val())){
		message("errorEditUser_"+uId, "L'email Perso doit être valide");
		return false;
	}
	if($('#tel3_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un numéro de portable");
		return false;
	}
	if($('#login_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un login");
		return false;
	}
	if($.inArray($('#login_'+uId).val(),loginList) >=0 && $('#login_'+uId).val() != log){
		message("errorEditUser_"+uId, "Ce login existe déjà");
		return false;
	}
	/*if($('#password_'+uId).val() == ""){
		message("errorEditUser_"+uId, "Merci de saisir un mot de passe");
		return false;
	}*/
	
	
	console.log('Edit user code : '+$('#code_'+uId).val());
	
	var data={};
	data["userId"] = uId;
	data["code"] = $('#code_'+uId).val();
	data["prenom"] = $('#prenom_'+uId).val();
	data["nom"] = $('#nom_'+uId).val();
	data["email"] = $('#email_'+uId).val();
	data["emailPerso"] = $('#emailPerso_'+uId).val();
	data["tel3"] = formatTel($('#tel3_'+uId).val());
	data["tel1"] = formatTel($('#tel1_'+uId).val());
	data["tel2"] = formatTel($('#tel2_'+uId).val());
	data["tel4"] = formatTel($('#tel4_'+uId).val());
	data["login"] = $('#login_'+uId).val();
	data["actif"] = $('#actif_'+uId).val();
	if($('#password_'+uId).val() != ""){
		data["pwd"] = $('#password_'+uId).val();
	}else{
		data["pwd"] = "noChange";
	}
	if($('#sendMail').prop('checked')){
		data["sendMail"] = 1;
	}else{
		data["sendMail"] = 0;
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/editUser.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditUser_"+uId, msg["content"]);
				loadCodeList('#codeList');
				loadLoginList('#loginList');
				loadUserList('#userList', 'tous', 'tous');
			}else{
				message("errorEditUser_"+uId, msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
	
}

function fetchUser()
{
	console.log("--- fetchUser() ---");
	message("errorFetchUser", "");
	message("confirmFetchUser", "");
	
	loadCodeList('#codeList');
	loadLoginList('#loginList');
	
	if($('#valueSearch').val() != ''){
		if($.isNumeric($('#valueSearch').val())){
			var mode = "code";
		}else if($('#valueSearch').val().indexOf('@') > -1){
			var mode = "email";
		}else{
			var mode = "nom";
		}
		var valeur = $('#valueSearch').val();
	}else{
		var mode = 'id';
		var valeur = $('#userList').val();
	}
	
	$('#resultFetch').css("display", "block");
	loadUserDetail('#userResultSearch', mode, valeur);
}

function loadUserTemp(el)
{
	console.log("--- loadUserTemp('"+el+"') ---");
	message("errorAddUserTemp", "");
	message("confirmAddUserTemp", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getUserTemp.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				for(var i=0; i < msg["content"].length; i++){
					var html = '<div class="userListElem" id="elem_'+i+'">';
					html += '<div class="userListElemTop">';
					html += '<div><b>'+msg["content"][i]["user_prenom"]+' '+msg["content"][i]["user_nom"]+'</b></div>';
					html += '<div>'+msg["content"][i]["user_email"]+'</div>';
					html += '<div>'+msg["content"][i]["user_tel3"]+'</div>';
					html += '</div>';
					html += '<div class="userListElemBottom">';
					html += '<div><input type="text" id="login_'+i+'" placeholder="Login"></div>';
					html += '<div><input type="text" id="pass_'+i+'" placeholder="Password"></div>';
					html += '<input type="hidden" id="code_'+i+'" value="'+msg["content"][i]["user_code"]+'">';
					html += '<div style="width: unset;"><div style="white-space: nowrap; text-align: left;"><label style="font-weight: normal !important;" for="email_'+i+'">Email : <input style="width: unset;" type="checkbox" id="email_'+i+'" name="email_'+i+'" checked></div></div>';
					html += '<div><button type="button" onClick="addUserTemp('+i+');">Ajouter</button></div>';
					html += '</div>';
					html += '<div class="errorMessage" id="errorAddUserTemp_'+i+'"></div>';
					html += '<div class="confirmMessage" id="confirmAddUserTemp_'+i+'"></div>';
					html += '</div>';
					elem.append(html);
				}
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function addUserTemp(i)
{
	console.log("--- addUserTemp('"+i+"') ---");
	message("errorAddUserTemp_"+i, "");
	message("confirmAddUserTemp_"+i, "");
	
	//$("#loader").css("display", "block");	
	// On récupère la liste de login
	var loginList = $('#loginList').html();
	console.log("loginList "+loginList);
	loginList = loginList.split('|');
	
	// Remplissage
	if($('#login_'+i).val() == ""){
		message("errorAddUserTemp_"+i, "Merci de saisir un login");
		return false;
	}
	console.log("Login "+$('#login_'+i).val());
	if($.inArray($('#login_'+i).val(),loginList) >=0){
		message("errorAddUserTemp_"+i, "Ce login existe déjà");
		return false;
	}
	
	if($('#pass_'+i).val() == ""){
		message("errorAddUserTemp_"+i, "Merci de saisir un mot de passe");
		return false;
	}
	
	console.log('Ajout user code : '+$('#code_'+i).val());
	var data={};
	data["code"] = $('#code_'+i).val();
	data["login"] = $('#login_'+i).val();
	data["pwd"] = $('#pass_'+i).val();
	if($('#email_'+i).prop('checked')){
		data["mail"] = 1;
	}else{
		data["mail"] = 0;
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addUserTemp.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmAddUserTemp_"+i, msg["content"]);
				loadLoginList('#loginList');
				$('#elem_'+i).fadeToggle(500);
			}else{
				message("errorAddUserTemp_"+i, msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function addUser()
{
	console.log("--- addUser() ---");
	message("errorAjoutUser", "");
	message("confirmAjoutUser", "");
	
	//$("#loader").css("display", "block");	
	// On récupère la liste de login
	var loginList = $('#loginList').html();
	console.log("loginList : "+loginList);
	loginList = loginList.split('|');
	
	// On récupère la liste de codes
	var codeList = $('#codeList').html();
	console.log("codeList : "+codeList);
	codeList = codeList.split('|');
	
	// Remplissage
	if($('#code').val() == ""){
		message("errorAjoutUser", "Merci de saisir un code");
		return false;
	}
	if($.inArray($('#code').val(),codeList) >=0 && $('#code').val()!=0){
		message("errorAjoutUser", "Ce code existe déjà");
		return false;
	}
	
	if($('#prenom').val() == ""){
		message("errorAjoutUser", "Merci de saisir un prénom");
		return false;
	}
	if($('#nom').val() == ""){
		message("errorAjoutUser", "Merci de saisir un nom");
		return false;
	}
	if($('#email').val() == ""){
		message("errorAjoutUser", "Merci de saisir un email");
		return false;
	}
	if(!isEmail($('#email').val())){
		message("errorAjoutUser", "Merci de saisir un email valide");
		return false;
	}
	if($('#emailPerso').val() != "" && !isEmail($('#emailPerso').val())){
		message("errorAjoutUser", "L'email Perso doit être valide");
		return false;
	}
	if($('#tel3').val() == ""){
		message("errorAjoutUser", "Merci de saisir un numéro de portable");
		return false;
	}
	if($('#login').val() == ""){
		message("errorAjoutUser", "Merci de saisir un login");
		return false;
	}
	if($.inArray($('#login').val(),loginList) >=0){
		message("errorAjoutUser", "Ce login existe déjà");
		return false;
	}
	if($('#password').val() == ""){
		message("errorAjoutUser", "Merci de saisir un mot de passe");
		return false;
	}
	
	
	console.log('Ajout user code : '+$('#code').val());
	
	var data={};
	data["code"] = $('#code').val();
	data["prenom"] = $('#prenom').val();
	data["nom"] = $('#nom').val();
	data["email"] = $('#email').val();
	data["emailPerso"] = $('#emailPerso').val();
	data["tel3"] = formatTel($('#tel3').val());
	data["tel1"] = formatTel($('#tel1').val());
	data["tel2"] = formatTel($('#tel2').val());
	data["tel4"] = formatTel($('#tel4').val());
	data["login"] = $('#login').val();
	data["pwd"] = $('#password').val();
	if($('#sendMail').prop('checked')){
		data["sendMail"] = 1;
	}else{
		data["sendMail"] = 0;
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addUser.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmAjoutUser", msg["content"]);
				loadLoginList('#loginList');
				loadCodeList('#codeList');
			}else{
				message("errorAjoutUser", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- PLANNINGS --------------------------------------------------------------------------------------------

function genSelectPlanningMonth(elem)
{
	console.log("--- genSelectPlanningMonth('"+elem+"') ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	var elem = $(elem);
	var date = new Date();
	var currentMonth = date.getMonth()+1;
	
	for(var i=1; i < 13; i++){
		if(i == currentMonth){
			var selected = " selected";
		}else{
			var selected = "";
		}		
		elem.append('<option value="'+i+'"'+selected+'>'+returnLitteralMonth(i)+'</b></option>');
	}
}

function genSelectPlanningYear(elem)
{
	console.log("--- genSelectPlanningYear('"+elem+"') ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	var elem = $(elem);
	var date = new Date();
	var currentYear = date.getFullYear();
	
	for(var i=2019; i < 2051; i++){
		if(i == currentYear){
			var selected = " selected";
		}else{
			var selected = "";
		}		
		elem.append('<option value="'+i+'"'+selected+'>'+i+'</b></option>');
	}	
}

function getPlanningList(elem, type, mode)
{
	console.log("--- getPlanningList('"+elem+"','"+type+"','"+mode+"') ---");
	message("errorGestionPlanning", "");
	message("confirmGestionPlanning", "");
	
	var elem = $(elem);
	
	var data={};
	data["type"] = type;
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getPlanningList.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				var html = '';
				for(var i=0; i < msg["content"].length; i++){
					html += "<option value='"+msg["content"][i]["mod_mois"]+"-"+msg["content"][i]["mod_annee"]+"'>"+returnLitteralMonth(msg["content"][i]["mod_mois"])+" "+msg["content"][i]["mod_annee"]+"</option>";
				}
				elem.html(html);
			}else{
				message("errorGestionPlanning", msg["content"]);
				elem.html("<option>"+msg["content"]+"</option>");
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorGestionPlanning", msg["content"]);
		}
	});
}

function deletePlanning(mode)
{
	console.log("--- deletePlanning('"+mode+"') ---");
	message("errorGestionPlanning", "");
	message("confirmGestionPlanning", "");
	
	var infos = $("#planning_gen").val();
	infos = infos.split('-')

	var data={};
	data["sent"] = 1;
	data["mois"] = infos[0];
	data["annee"] = infos[1];
	data["mode"] = mode;
	
	$("#loader").css("display", "block");
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deletePlanning.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				getPlanningList('#planning_gen','all',mode);
				getPlanningList('#planning_pending','pending',mode);
				$("#loader").css("display", "none");
			}else{
				message("errorGestionPlanning", msg["content"]);
				$("#loader").css("display", "none");
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorGestionPlanning", msg["content"]);
			$("#loader").css("display", "none");
		}
	});
}

function validePlanning(mode)
{
	console.log("--- validePlanning('"+mode+"') ---");
	message("errorGestionPlanning", "");
	message("confirmGestionPlanning", "");
	
	var infos = $("#planning_pending").val();
	infos = infos.split('-')

	var data={};
	data["sent"] = 1;
	data["mois"] = infos[0];
	data["annee"] = infos[1];
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/validePlanning.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				getPlanningList('#planning_pending','pending',mode);
			}else{
				message("errorGestionPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorGestionPlanning", msg["content"]);
		}
	});
}

function getLastPlanning(el, mode)
{
	console.log("--- getLastPlanning('"+el+"','"+mode+"') ---");
	message("errorGenPlanning", "");
	
	var elemHidden = $(el+"Hidden");
	var elem = $(el);
	
	var data={};
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getLastPlanning.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				if(msg["content"] == "Pas de résultat"){
					elem.html("Aucun planning trouvé");
				}else{
					var retour = msg["content"][1]+" "+msg["content"][0][1];
					elem.html("Dernier planning créé : <b>"+retour+"</b>");
					elemHidden.val(msg["content"][0][0]+"/"+msg["content"][0][1]);
				}				
			}else{
				message("errorModGen", msg["content"]);
			}
			return retour;
		},
		error: function(msg){
			console.log("getLastPlanning ERROR MESSAGE : "+msg["content"]);
			message("errorModGen", msg["content"]);
		}
	});
}

function getCoordinateurs(el,mode)
{
	console.log("--- getCoordinateurs("+el+","+mode+") ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	var elem = $(el);
	
	var data={};
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getCoordinateurs.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			//console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				var html = '';
				for(var i=0; i < msg["content"].length; i++){
					html += "<option value='"+msg["content"][i]["user_id"]+"'>"+msg["content"][i]["user_nom"]+" "+msg["content"][i]["user_prenom"]+"</option>";
				}
				elem.append(html);
				message("confirmGenPlanning", msg["content"]);
			}else{
				message("errorGenPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});	
}

function getObservateurs(el,mode)
{
	console.log("--- getObservateurs("+el+","+mode+") ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	var elem = $(el);
	
	var data={};
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getObservateurs.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			//console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				var html = '<option value="none">Choisir</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += "<option value='"+msg["content"][i]["user_id"]+"'>"+msg["content"][i]["user_nom"]+" "+msg["content"][i]["user_prenom"]+"</option>";
				}
				elem.append(html);
				message("confirmGenPlanning", msg["content"]);
			}else{
				message("errorGenPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});	
}

function addObservateurs()
{
	console.log("--- addObservateurs() ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	if($('#obsMaj_1_1').val() == 'none' && $('#obsMaj_2_1').val() == 'none' && $('#obsMin_1').val() == 'none' && $('#obsEtr_1').val() == 'none' && $('#obsSSC_1').val() == 'none'){
		message("errorGenPlanning", "Merci de choisir au moins un observateur à ajouter.");
		return false;
	}
		
	var data={};
	data["sent"] = 1;
	data["mois"] = $('#mois').val();
	data["annee"] = $('#annee').val();
	data["coord"] = $('#coord_1').val();
	data["maj_1"] = $('#obsMaj_1_1').val();
	data["maj_2"] = $('#obsMaj_2_1').val();
	data["min"] = $('#obsMin_1').val();
	data["etr"] = $('#obsEtr_1').val();
	data["ssc"] = $('#obsSSC_1').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addObservateurs.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmGenPlanning", msg["content"]);
			}else{
				message("errorGenPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function genPlanningPP()
{
	console.log("--- genPlanningPP() ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	if($("#coord_1").val() == $("#coord_2").val() || $("#coord_1").val() == $("#coord_3").val() || $("#coord_2").val() == $("#coord_3").val()){
		message("errorGenPlanning", "Veuillez sélectionner des coordinateurs différents");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["mois"] = $("#mois").val();
	data["annee"] = $("#annee").val();
	data["coord_1"] = $("#coord_1").val();
	data["coord_2"] = $("#coord_2").val();
	data["coord_3"] = $("#coord_3").val();
	data["obsMaj_1_1"] = $("#obsMaj_1_1").val();
	data["obsMaj_2_1"] = $("#obsMaj_2_1").val();
	data["obsMaj_1_2"] = $("#obsMaj_1_2").val();
	data["obsMaj_2_2"] = $("#obsMaj_2_2").val();
	data["obsMaj_1_3"] = $("#obsMaj_1_3").val();
	data["obsMaj_2_3"] = $("#obsMaj_2_3").val();
	data["obsMin_1"] = $("#obsMin_1").val();
	data["obsMin_2"] = $("#obsMin_2").val();
	data["obsMin_3"] = $("#obsMin_3").val();
	data["obsEtr_1"] = $("#obsEtr_1").val();
	data["obsEtr_2"] = $("#obsEtr_2").val();
	data["obsEtr_3"] = $("#obsEtr_3").val();
	data["obsSSC_1"] = $("#obsSSC_1").val();
	data["obsSSC_2"] = $("#obsSSC_2").val();
	data["obsSSC_3"] = $("#obsSSC_3").val();
	
	console.log(data["mois"]+','+data["annee"]+','+data["coord_1"]+','+data["coord_2"]+','+data["coord_3"]+','+data["obsMaj_1_1"]+','+data["obsMaj_2_1"]+','+data["obsMaj_1_2"]+','+data["obsMaj_2_2"]+','+data["obsMaj_1_3"]+','+data["obsMaj_2_3"]+','+data["obsMin_1"]+','+data["obsMin_2"]+','+data["obsMin_3"]+','+data["obsEtr_1"]+','+data["obsEtr_2"]+','+data["obsEtr_3"]+','+data["obsSSC_1"]+','+data["obsSSC_2"]+','+data["obsSSC_3"]);
	
	$("#loader").css("display", "block");
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/genPlanningPP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				$("#loader").css("display", "none");
				message("confirmGenPlanning", msg["content"]);
				getLastPlanning('#lastPlanning', 'palais');
			}else{
				$("#loader").css("display", "none");
				message("errorGenPlanning", msg["content"]);
			}
		},
		error: function(msg){
			$("#loader").css("display", "none");
			console.log(msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});	
}

function loadPlanningPP(el,mois,annee)
{
	console.log("--- loadPlanningPP("+el+","+mois+","+annee+") ---");
	message("errorPlanning", "");
	message("confirmPlanning", "");
	
	$('#printLine').css('display', 'block');
	$('#moisHidden').val(mois);
	$('#anneeHidden').val(annee);
	
	var elem = $(el);
	var elemTitre = $(el+'Titre');
	var elemTitreHidden = $(el+'TitreHidden');
	elem.html('');	
	elemTitre.html('');
	elemTitreHidden.val('');
	
	var data={};
	data["sent"] = 1;
	data["mois"] = mois;
	data["annee"] = annee;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getPlanningPP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				for(var i=0; i < msg["content"].length; i++){
					var html = '';
					//message("confirmGenPlanning", msg["content"]);
					html += '<div class="module">';
					html += '<div class="entete">'+msg["content"][i]["dates"]+'</div>';
					html += '<div class="coordinateurTitre">Coordinateur</div>';
					html += '<div class="coordinateur">'+msg["content"][i]["coord"]+'</div>';
					html += '<div class="interMajTitre">Intervenants Majeurs</div>';
					html += '<div class="interMaj">'+msg["content"][i]["interMaj"]+'</div>';
					html += '<div class="obsMajTitre">Observateurs Majeurs</div>';
					html += '<div class="obsMaj">'+msg["content"][i]["obsMaj"]+'</div>';
					html += '<div class="interMinTitre">Intervenants Mineurs</div>';
					html += '<div class="interMin">'+msg["content"][i]["interMin"]+'</div>';
					html += '<div class="obsMinTitre">Observateurs Mineurs</div>';
					html += '<div class="obsMin">'+msg["content"][i]["obsMin"]+'</div>';
					html += '<div class="interEtrTitre">Intervenants Etrangers</div>';
					html += '<div class="interEtr">'+msg["content"][i]["interEtr"]+'</div>';
					html += '<div class="obsEtrTitre">Observateurs Etrangers</div>';
					html += '<div class="obsEtr">'+msg["content"][i]["obsEtr"]+'</div>';
					html += '<div class="interHoTitre">Intervenants H.O.</div>';
					html += '<div class="interHo">'+msg["content"][i]["interSSC"]+'</div>';
					html += '<div class="obsHoTitre">Obervateurs H.O.</div>';
					html += '<div class="obsHo">'+msg["content"][i]["obsSSC"]+'</div>';
					html += '</div>';
					elem.append(html);
				}
				elemTitre.html(returnLitteralMonth(mois)+" "+annee);
				elemTitreHidden.val(mois);
			}else{
				$('#printLine').css('display', 'none');
				elemTitreHidden.val(mois);
				message("errorPlanning", msg["content"]);
			}
		},
		error: function(msg){
			$('#printLine').css('display', 'none');
			message("errorPlanning", msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});	
	
}

function addUserPlanningPP()
{
	console.log("--- addUserPlanning() ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	if($('#userList').val() == 'tous'){
		message("errorEditPlanning", "Veuillez sélectionner un utilisateur");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["mod_id"] = $('#mod_id').val();
	data["user_id"] = $('#userList').val();
	data["role_id"] = $('#userRole').val();
	data["perm_id"] = $('#userPerm').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addUserPlanningPP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditPlanning", msg["content"]);
				loadModulePP('#wrapperModule',$('#dateHidden').val());
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log(msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function deleteUserPlanningPP(userId,modId)
{
	console.log("--- deleteUserPlanningPP() ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	var data={};
	data["sent"] = 1;
	data["mod_id"] = modId;
	data["user_id"] = userId;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deleteUserPlanningPP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditPlanning", msg["content"]);
				loadModulePP('#wrapperModule',$('#dateHidden').val());
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function loadModulePP(el,date)
{
	console.log("--- loadModulePP("+el+","+date+") ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	$('#addUserWrapper').css('display','none');
	
	var elem = $(el);
	elem.html("");
	var html = "";
	var coord = "";
	var interMaj = "";
	var obsMaj = "";
	var interMin = "";
	var obsMin = "";
	var interEtr = "";
	var obsEtr = "";
	var interSSC = "";
	var obsSSC = "";
	
	var data={};
	data["sent"] = 1;
	data["date"] = date;

	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getModulePP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				html += '<div class="module"><input type="hidden" id="mod_id" value="'+msg["content"]["mod_id"]+'">';
				date = $('#datepicker').val();
				html += '<div class="entete" style="height:unset;">'+date+'</div>';
				for(var i=0; i<msg["content"]["coord"].length; i++){
					coord += '<div class="editUser">'+msg["content"]["coord"][i][1]+' '+msg["content"]["coord"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["coord"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="coordinateurTitre">Coordinateur</div>';
				html += '<div class="coordinateur">'+coord+'</div>';
				for(var i=0; i<msg["content"]["interMaj"].length; i++){
					interMaj += '<div class="editUser">'+msg["content"]["interMaj"][i][1]+' '+msg["content"]["interMaj"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["interMaj"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="interMajTitre">Intervenants Majeurs</div>';
				html += '<div class="interMaj">'+interMaj+'</div>';
				
				for(var i=0; i<msg["content"]["obsMaj"].length; i++){
					obsMaj += '<div class="editUser">'+msg["content"]["obsMaj"][i][1]+' '+msg["content"]["obsMaj"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["obsMaj"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="obsMajTitre">Observateurs Majeurs</div>';
				html += '<div class="obsMaj">'+obsMaj+'</div>';
				
				for(var i=0; i<msg["content"]["interMin"].length; i++){
					interMin += '<div class="editUser">'+msg["content"]["interMin"][i][1]+' '+msg["content"]["interMin"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["interMin"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="interMinTitre">Intervenants Mineurs</div>';
				html += '<div class="interMin">'+interMin+'</div>';
				
				for(var i=0; i<msg["content"]["obsMin"].length; i++){
					obsMin += '<div class="editUser">'+msg["content"]["obsMin"][i][1]+' '+msg["content"]["obsMin"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["obsMin"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="obsMinTitre">Observateurs Mineurs</div>';
				html += '<div class="obsMin">'+obsMin+'</div>';
				
				for(var i=0; i<msg["content"]["interEtr"].length; i++){
					interEtr += '<div class="editUser">'+msg["content"]["interEtr"][i][1]+' '+msg["content"]["interEtr"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["interEtr"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="interEtrTitre">Intervenants Etrangers</div>';
				html += '<div class="interEtr">'+interEtr+'</div>';
				
				for(var i=0; i<msg["content"]["obsEtr"].length; i++){
					obsEtr += '<div class="editUser">'+msg["content"]["obsEtr"][i][1]+' '+msg["content"]["obsEtr"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["obsEtr"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="obsEtrTitre">Observateurs Etrangers</div>';
				html += '<div class="obsEtr">'+obsEtr+'</div>';
				
				for(var i=0; i<msg["content"]["interSSC"].length; i++){
					interSSC += '<div class="editUser">'+msg["content"]["interSSC"][i][1]+' '+msg["content"]["interSSC"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["interSSC"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="interHoTitre">Intervenants H.O.</div>';
				html += '<div class="interHo">'+interSSC+'</div>';
				
				for(var i=0; i<msg["content"]["obsSSC"].length; i++){
					obsSSC += '<div class="editUser">'+msg["content"]["obsSSC"][i][1]+' '+msg["content"]["obsSSC"][i][2]+'<button title="Supprimer" onClick="deleteUserPlanningPP('+msg["content"]["obsSSC"][i][0]+','+msg["content"]["mod_id"]+');"><img src="images/icons/icon-delete.png"></button></div><br>';
				}
				html += '<div class="obsHoTitre">Obervateurs H.O.</div>';
				html += '<div class="obsHo">'+obsSSC+'</div>';
				html += '</div>'
				$('#addUserWrapper').css('display','flex');
				elem.append(html);
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			message("errorEditPlanning", msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
}

function loadJourPP(el,date)
{
	console.log("--- loadJourPP("+el+","+date+") ---");
	message("errorJourPP", "");
	message("confirmJourPP", "");
	
	$('#printLine').css('display', 'block');
	
	var elem = $(el);
	elem.html("");
	var data={};
	data["sent"] = 1;
	data["date"] = date;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getJourPP.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				var html = "";
				html += '<div class="module">';
				$('#datepicker').datepicker('setDate', new Date(date));
				dateFull = $('#datepicker').val();
				var coord = "";
				html += '<div class="entete" style="height:unset; font-size: 22px;">'+dateFull+'</div><input type="hidden" id="currentDateHidden" value="'+date+'">';
				if(msg["content"]["notes"].length > 0){
					html += '<div class="notesTitre">Notes du jour</div>';
					for(var i=0; i< msg["content"]["notes"].length;i++){
						html += '<div class="notes">'+msg["content"]["notes"][i]["note_text"]+'</div>';
					}
				}
				for(var i=0; i< msg["content"]["coord"].length;i++){
					coord += "Me <b>"+msg["content"]["coord"][i]["infos"]["user_nom"]+" "+msg["content"]["coord"][i]["infos"]["user_prenom"]+"</b>";
				}
				html += '<div class="coordinateurTitre">Coordinateur</div>';
				html += '<div class="coordinateur">'+coord+'</div>';
				html += '<div class="interMajTitre">Intervenants Majeurs</div>';
				var interMaj = "";
				for(var i=0; i< msg["content"]["interMaj"].length;i++){
					interMaj += "<div class='avocat'>Me "+msg["content"]["interMaj"][i]["infos"]["user_nom"]+" "+msg["content"]["interMaj"][i]["infos"]["user_prenom"]+"</div>";
					for(var j=0; j<msg["content"]["interMaj"][i]["des"].length; j++){
						interMaj += "<div class='desAvocat'>- ";
						if(msg["content"]["interMaj"][i]["des"][j]["des_heure"] != "00:00:00"){
							var heure = msg["content"]["interMaj"][i]["des"][j]["des_heure"]+" | ";
						}else{
							var heure = "";
						}
						if(msg["content"]["interMaj"][i]["des"][j]["des_juge"] != ""){
							var juge = " | Juge : "+msg["content"]["interMaj"][i]["des"][j]["des_juge"];
						}else{
							var juge = "";
						}
						if(msg["content"]["interMaj"][i]["des"][j]["des_affaire"] != ""){
							var affaire = " | Affaire : "+msg["content"]["interMaj"][i]["des"][j]["des_affaire"];
						}else{
							var affaire = "";
						}
						interMaj += heure+msg["content"]["interMaj"][i]["des"][j]["nature_libelle"]+" | ";
						interMaj += msg["content"]["interMaj"][i]["des"][j]["des_prevNom"]+" "+msg["content"]["interMaj"][i]["des"][j]["des_prevPrenom"]+juge+affaire;
						interMaj += "</div>";
					}
					if(i != msg["content"]["interMaj"].length-1){
						interMaj += "<hr>";
					}
				}
				html += '<div class="interMaj">'+interMaj+'</div>';
				//html += '<div class="avocat">Me BERTRAND Rémi<br>05/11/2019 à 08:30 - TC - David LAMOTTE - Affaire :192450000111</div>';
				var obsMaj = "";
				for(var i=0; i< msg["content"]["obsMaj"].length;i++){
					obsMaj += "<div class='avocat'>Me "+msg["content"]["obsMaj"][i]["infos"]["user_nom"]+" "+msg["content"]["obsMaj"][i]["infos"]["user_prenom"]+"</div>";
				}
				html += '<div class="obsMajTitre">Observateurs Majeurs</div>';
				html += '<div class="obsMaj">'+obsMaj+'</div>';
				var interMin = "";
				for(var i=0; i< msg["content"]["interMin"].length;i++){
					interMin += "<div class='avocat'>Me "+msg["content"]["interMin"][i]["infos"]["user_nom"]+" "+msg["content"]["interMin"][i]["infos"]["user_prenom"]+"</div>";
					for(var j=0; j<msg["content"]["interMin"][i]["des"].length; j++){
						interMin += "<div class='desAvocat'>";
						if(msg["content"]["interMin"][i]["des"][j]["des_heure"] != "00:00:00"){
							var heure = msg["content"]["interMin"][i]["des"][j]["des_heure"]+" | ";
						}else{
							var heure = "";
						}
						if(msg["content"]["interMin"][i]["des"][j]["des_juge"] != ""){
							var juge = " | Juge : "+msg["content"]["interMin"][i]["des"][j]["des_juge"];
						}else{
							var juge = "";
						}
						if(msg["content"]["interMin"][i]["des"][j]["des_affaire"] != ""){
							var affaire = " | Affaire : "+msg["content"]["interMin"][i]["des"][j]["des_affaire"];
						}else{
							var affaire = "";
						}
						interMin += heure+msg["content"]["interMin"][i]["des"][j]["nature_libelle"]+" | ";
						interMin += msg["content"]["interMin"][i]["des"][j]["des_prevNom"]+" "+msg["content"]["interMin"][i]["des"][j]["des_prevPrenom"]+juge+affaire;
						interMin += "</div>";
					}
					if(i != msg["content"]["interMin"].length-1){
						interMin += "<hr>";
					}
				}
				html += '<div class="interMinTitre">Intervenants Mineurs</div>';
				html += '<div class="interMin">'+interMin+'</div>';
				var obsMin = "";
				for(var i=0; i< msg["content"]["obsMin"].length;i++){
					obsMin += "<div class='avocat'>Me "+msg["content"]["obsMin"][i]["infos"]["user_nom"]+" "+msg["content"]["obsMin"][i]["infos"]["user_prenom"]+"</div>";
				}
				html += '<div class="obsMinTitre">Observateurs Mineurs</div>';
				html += '<div class="obsMin">'+obsMin+'</div>';
				var interEtr = "";
				for(var i=0; i< msg["content"]["interEtr"].length;i++){
					interEtr += "<div class='avocat'>Me "+msg["content"]["interEtr"][i]["infos"]["user_nom"]+" "+msg["content"]["interEtr"][i]["infos"]["user_prenom"]+"</div>";
					for(var j=0; j<msg["content"]["interEtr"][i]["des"].length; j++){
						interEtr += "<div class='desAvocat'>";
						if(msg["content"]["interEtr"][i]["des"][j]["des_heure"] != "00:00:00"){
							var heure = msg["content"]["interEtr"][i]["des"][j]["des_heure"]+" | ";
						}else{
							var heure = "";
						}
						if(msg["content"]["interEtr"][i]["des"][j]["des_juge"] != ""){
							var juge = " | Juge : "+msg["content"]["interEtr"][i]["des"][j]["des_juge"];
						}else{
							var juge = "";
						}
						if(msg["content"]["interEtr"][i]["des"][j]["des_affaire"] != ""){
							var affaire = " | Affaire : "+msg["content"]["interEtr"][i]["des"][j]["des_affaire"];
						}else{
							var affaire = "";
						}
						interEtr += heure+msg["content"]["interEtr"][i]["des"][j]["nature_libelle"]+" | ";
						interEtr += msg["content"]["interEtr"][i]["des"][j]["des_prevNom"]+" "+msg["content"]["interEtr"][i]["des"][j]["des_prevPrenom"]+juge+affaire;
						interEtr += "</div>";
					}
					if(i != msg["content"]["interEtr"].length-1){
						interEtr += "<hr>";
					}
				}
				html += '<div class="interEtrTitre">Intervenants Etrangers</div>';
				html += '<div class="interEtr">'+interEtr+'</div>';
				var obsEtr = "";
				for(var i=0; i< msg["content"]["obsEtr"].length;i++){
					obsEtr += "<div class='avocat'>Me "+msg["content"]["obsEtr"][i]["infos"]["user_nom"]+" "+msg["content"]["obsEtr"][i]["infos"]["user_prenom"]+"</div>";
				}
				html += '<div class="obsEtrTitre">Observateurs Etrangers</div>';
				html += '<div class="obsEtr">'+obsEtr+'</div>';
				var interHo = "";
				for(var i=0; i< msg["content"]["interHo"].length;i++){
					interHo += "<div class='avocat'>Me "+msg["content"]["interHo"][i]["infos"]["user_nom"]+" "+msg["content"]["interHo"][i]["infos"]["user_prenom"]+"</div>";
					for(var j=0; j<msg["content"]["interHo"][i]["des"].length; j++){
						interHo += "<div class='desAvocat'>";
						if(msg["content"]["interHo"][i]["des"][j]["des_heure"] != "00:00:00"){
							var heure = msg["content"]["interHo"][i]["des"][j]["des_heure"]+" | ";
						}else{
							var heure = "";
						}
						if(msg["content"]["interHo"][i]["des"][j]["des_juge"] != ""){
							var juge = " | Juge : "+msg["content"]["interHo"][i]["des"][j]["des_juge"];
						}else{
							var juge = "";
						}
						if(msg["content"]["interHo"][i]["des"][j]["des_affaire"] != ""){
							var affaire = " | Affaire : "+msg["content"]["interHo"][i]["des"][j]["des_affaire"];
						}else{
							var affaire = "";
						}
						interHo += heure+msg["content"]["interHo"][i]["des"][j]["nature_libelle"]+" | ";
						interHo += msg["content"]["interHo"][i]["des"][j]["des_prevNom"]+" "+msg["content"]["interHo"][i]["des"][j]["des_prevPrenom"]+juge+affaire;
						interHo += "</div>";
					}
					if(i != msg["content"]["interHo"].length-1){
						interHo += "<hr>";
					}
				}
				html += '<div class="interHoTitre">Intervenants SSC</div>';
				html += '<div class="interHo">'+interHo+'</div>';
				var obsHo = "";
				for(var i=0; i< msg["content"]["obsHo"].length;i++){
					obsHo += "<div class='avocat'>Me "+msg["content"]["obsHo"][i]["infos"]["user_nom"]+" "+msg["content"]["obsHo"][i]["infos"]["user_prenom"]+"</div>";
				}
				html += '<div class="obsHoTitre">Observateurs SSC</div>';
				html += '<div class="obsHo">'+obsHo+'</div>';
				html += '</div>';
				if(msg["content"]["designations"].length > 0){
					var designations = "<div class='designations'><div class='designationsTitre'>Désignations</div>";
					for(var i=0; i< msg["content"]["designations"].length;i++){
						if(msg["content"]["designations"][i]["des_heure"] != "00:00:00"){
							var heure = " | "+msg["content"]["designations"][i]["des_heure"];
						}else{
							var heure = "";
						}
						if(msg["content"]["designations"][i]["des_juge"] != ""){
							var juge = " | Juge : "+msg["content"]["designations"][i]["des_juge"];
						}else{
							var juge = "";
						}
						if(msg["content"]["designations"][i]["des_affaire"] != ""){
							var affaire = " | Affaire : "+msg["content"]["designations"][i]["des_affaire"];
						}else{
							var affaire = "";
						}
						designations += "<div class='designation'><b>- Me "+msg["content"]["designations"][i]["user_nom"]+" "+msg["content"]["designations"][i]["user_prenom"]+"</b>"+heure;
						designations += " | "+msg["content"]["designations"][i]["nature_libelle"];
						designations += " | "+msg["content"]["designations"][i]["des_prevPrenom"]+" "+msg["content"]["designations"][i]["des_prevNom"];
						designations += juge+affaire;
						designations += "</div>";
						if(i != msg["content"]["designations"].length-1){
							designations += "<hr>";
						}
					}
					designations += "</div>";
					html += designations;
				}
				elem.html(html);
			}else{
				$('#printLine').css('display', 'none');
				message("errorJourPP", msg["content"]);
			}
		},
		error: function(msg){
			message("errorJourPP", msg["content"]);
			$('#printLine').css('display', 'none');
			console.log(msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- PLANNINGS GAV ----------------------------------------------------------------------------------------------------

function genPlanningGAV()
{
	console.log("--- genPlanningGAV() ---");
	message("errorGenPlanning", "");
	message("confirmGenPlanning", "");
	
	if($("#coord_1").val() == $("#coord_2").val() || $("#coord_1").val() == $("#coord_3").val() || $("#coord_2").val() == $("#coord_3").val()){
		message("errorGenPlanning", "Veuillez sélectionner des coordinateurs différents");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["mois"] = $("#mois").val();
	data["annee"] = $("#annee").val();
	data["coord_1"] = $("#coord_1").val();
	data["coord_2"] = $("#coord_2").val();
	data["coord_3"] = $("#coord_3").val();
	
	console.log(data["mois"]+','+data["annee"]+','+data["coord_1"]+','+data["coord_2"]+','+data["coord_3"]);
	$("#loader").css("display", "block");
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/genPlanningGAV.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				$("#loader").css("display", "none");
				message("confirmGenPlanning", msg["content"]);
				getLastPlanning('#lastPlanning', 'gav');
			}else{
				$("#loader").css("display", "none");
				message("errorGenPlanning", msg["content"]);
			}
		},
		error: function(msg){
			$("#loader").css("display", "none");
			console.log(msg["content"]);
			console.log("genPlanningGAV ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});	
}

function loadPlanningGAV(el,mois,annee)
{
	console.log("--- loadPlanningGAV("+el+","+mois+","+annee+") ---");
	message("errorPlanning", "");
	message("confirmPlanning", "");
	
	$('#printLine').css('display', 'none');
	
	var elem = $(el);
	var elemTitre = $(el+'Titre');
	var elemTitreHidden = $(el+'TitreHidden');
	elem.html('');	
	elemTitre.html('');
	elemTitreHidden.val('');
	
	var data={};
	data["sent"] = 1;
	data["mois"] = mois;
	data["annee"] = annee;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getPlanningGAV.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				for(var i=0; i < msg["content"].length; i++){
					var html = '';
					//message("confirmGenPlanning", msg["content"]);
					html += '<div class="jourGAV">';
					html += '<div class="dateGAV">'+msg["content"][i][0]+'</div>';
					html += '<div class="coordGAVTitre">Coordinateur</div>';
					var coord = "";
					for(var j=0; j < msg["content"][i][1].length; j++){
						coord += msg["content"][i][1][j]["user_nom"]+" "+msg["content"][i][1][j]["user_prenom"]+"<br>Tel : <a href='tel:"+msg["content"][i][1][j]["user_tel3"]+"' class='telephone'>"+msg["content"][i][1][j]["user_tel3"]+"</a>";
					}
					html += '<div class="coordGAV">'+coord+'</div>';
					html += '<div class="interGAVTitre">Intervenants</div>';
					html += '<div class="interGAVWrapper">';
					for(var j=0; j < msg["content"][i][2].length; j++){
						html += '<div class="interGAV">'+msg["content"][i][2][j]["user_nom"]+' '+msg["content"][i][2][j]["user_prenom"]+'<br>'+msg["content"][i][2][j]["user_inter"]+'Tel : <a href="tel:'+msg["content"][i][2][j]["user_tel3"]+'" class="telephone">'+msg["content"][i][2][j]["user_tel3"]+'</a></div>';
					}
					html += '</div>';
					html += '<div class="interGAVFooter"> </div>';
					html += '</div>';
					elem.append(html);
				}
				elemTitre.html(returnLitteralMonth(mois)+" "+annee);
				elemTitreHidden.val(mois);
				$('#moisHidden').val(mois);
				$('#anneeHidden').val(annee);
				$('#printLine').css('display', 'block');
			}else{
				$('#printLine').css('display', 'none');
				elemTitreHidden.val(mois);
				message("errorPlanning", msg["content"]);
			}
		},
		error: function(msg){
			$('#printLine').css('display', 'none');
			message("errorPlanning", msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});	
	
}

function loadUserGAVList(el)
{
	console.log("--- loadUserGAVList('"+el+"') ---");
	message("errorLoginList", "");
	message("confirmLoginList", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	elem.find('option').remove().end();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getUserGAVList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '<option value="tous">--- Choisir ---</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += '<option value="'+msg["content"][i]["user_id"]+'">'+msg["content"][i]["user_code"]+' : '+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+'</option>';
				}
				elem.append(html);
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function addUserPlanningGAV()
{
	console.log("--- addUserPlanningGAV() ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	if($('#userList').val() == 'tous'){
		message("errorEditPlanning", "Veuillez sélectionner un utilisateur");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["mod_id"] = $('#mod_id').val();
	data["date"] = $('#date').val();
	data["user_id"] = $('#userList').val();
	data["role_id"] = $('#userRole').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addUserPlanningGAV.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditPlanning", msg["content"]);
				loadJourGAV('#wrapperModule',$('#date').val());
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log(msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function deleteUserPlanningGAV(user_id, mod_id, date, mode)
{
	console.log("--- deleteUserPlanningGAV() ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	var data={};
	data["sent"] = 1;
	data["date"] = date;
	data["mod_id"] = mod_id;
	data["user_id"] = user_id;
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deleteUserPlanningGAV.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmEditPlanning", msg["content"]);
				loadJourGAV('#wrapperModule',date);
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

function loadJourGAV(el,date)
{
	console.log("--- loadJourGAV("+el+","+date+") ---");
	message("errorEditPlanning", "");
	message("confirmEditPlanning", "");
	
	$('#addUserWrapper').css('display','none');
	
	var elem = $(el);
	elem.html("");
	var html = "";
	
	var coord = "";
	var inter = "";
	
	
	var data={};
	data["sent"] = 1;
	data["date"] = date;

	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getJourGAV.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				html += '<div class="jourGAV"><input type="hidden" id="date" value="'+date+'">';
				html += '<div class="dateGAV">'+msg["content"]["date"]+'</div>';
				html += '<div class="coordGAVTitre">Coordinateur</div>';
				for(var i=0; i<msg["content"]["coord"].length; i++){
					html += '<div class="editUser" style="background-color: #52a4cb;">'+msg["content"]["coord"][i]['user_nom']+' '+msg["content"]["coord"][i]['user_prenom']+'<button title="Supprimer" onClick="deleteUserPlanningGAV('+msg["content"]["coord"][i]['user_id']+','+msg["content"]["coord"][i]['mod_id']+',\''+date+'\',\'coord\');"><img src="images/icons/icon-delete.png"></button></div>';
					console.log("Mod id : "+msg["content"]["coord"][i]['mod_id']);
					var mod_id = msg["content"]["coord"][i]['mod_id'];
				}
				html += '<input type="hidden" id="mod_id" value="'+mod_id+'">';
				html += '<div class="interGAVTitre">Intervenants</div>';
				html += '<div class="interGAVWrapper" style="height:unset;">';
				for(var i=0; i<msg["content"]["inter"].length; i++){
					html += '<div class="editUser">'+msg["content"]["inter"][i]['user_nom']+' '+msg["content"]["inter"][i]['user_prenom']+'<button title="Supprimer" onClick="deleteUserPlanningGAV('+msg["content"]["inter"][i]['user_id']+','+mod_id+',\''+date+'\',\'inter\');"><img src="images/icons/icon-delete.png"></button></div>';
				}
				html += '</div>';
				html += '<div class="interGAVFooter"></div>';
				html += '</div>'
				$('#addUserWrapper').css('display','flex');
				elem.append(html);
			}else{
				message("errorEditPlanning", msg["content"]);
			}
		},
		error: function(msg){
			message("errorEditPlanning", msg["content"]);
			console.log("ERROR MESSAGE : "+msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- DISPOS GAV -----------------------------------------------------------------------------------------------------

function loadDispoList(el)
{
	console.log("--- loadDispoList('"+el+"') ---");
	message("errorDispos", "");
	message("confirmDispos", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	html = "";
	elem.html("");
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDispoList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			//console.log(msg["content"]);
			html += '<div class="dispoElem" style="background: #9dcfe7; font-weight:bold;"><div class="avocat" style="text-align:center;">INTERVENANTS</div><div class="jour">Lun</div><div class="jour">Mar</div><div class="jour">Mer</div><div class="jour">Jeu</div><div class="jour">Ven</div><div class="jour">Sam</div><div class="jour">Dim</div></div>';
			if(msg["code"] == "ok"){
				var buff = [];
				for(var i=0; i < msg["content"].length; i++ ){
					buff.push(msg["content"][i]["user_id"]);
					if(msg["content"][i]["dispo_lun"] == 1){
						var lundi = "checked";
					}else{
						var lundi = "";
					}
					if(msg["content"][i]["dispo_mar"] == 1){
						var mardi = "checked";
					}else{
						var mardi = "";
					}
					if(msg["content"][i]["dispo_mer"] == 1){
						var mercredi = "checked";
					}else{
						var mercredi = "";
					}
					if(msg["content"][i]["dispo_jeu"] == 1){
						var jeudi = "checked";
					}else{
						var jeudi = "";
					}
					if(msg["content"][i]["dispo_ven"] == 1){
						var vendredi = "checked";
					}else{
						var vendredi = "";
					}
					if(msg["content"][i]["dispo_sam"] == 1){
						var samedi = "checked";
					}else{
						var samedi = "";
					}
					if(msg["content"][i]["dispo_dim"] == 1){
						var dimanche = "checked";
					}else{
						var dimanche = "";
					}
					html += '<div class="dispoElem"><div class="avocat">'+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+'</div>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_lun"><div class="jour"><input type="checkbox" title="Lundi" '+lundi+' id="'+msg["content"][i]["user_id"]+'_lun"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_mar"><div class="jour"><input type="checkbox" title="Mardi" '+mardi+' id="'+msg["content"][i]["user_id"]+'_mar"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_mer"><div class="jour"><input type="checkbox"  title="Mercredi" '+mercredi+' id="'+msg["content"][i]["user_id"]+'_mer"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_jeu"><div class="jour"><input type="checkbox" title="Jeudi" '+jeudi+' id="'+msg["content"][i]["user_id"]+'_jeu"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_ven"><div class="jour"><input type="checkbox" title="Vendredi" '+vendredi+' id="'+msg["content"][i]["user_id"]+'_ven"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_sam"><div class="jour"><input type="checkbox" title="Samedi" '+samedi+' id="'+msg["content"][i]["user_id"]+'_sam"></div></label>';
					html += '<label for="'+msg["content"][i]["user_id"]+'_dim"><div class="jour"><input type="checkbox" title="Dimanche" '+dimanche+' id="'+msg["content"][i]["user_id"]+'_dim"></div></div></label>';
				}
				var idList = "";
				for(var i=0; i < buff.length; i++ ){
					idList += buff[i];
					if(i < buff.length-1){
						idList += "-";
					}
				}
				html += '<input type="hidden" id="idList" value="'+idList+'">';
				$("#loader").css("display", "none");
				elem.append(html);
			}else{
				message("errorDispos", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorDispos", msg["content"]);
		}
	});
}

function loadCompteur(el, mode)
{
	console.log("--- loadCompteur('"+el+"','"+mode+"') ---");
	message("errorDispos", "");
	message("confirmDispos", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	html = "";
	elem.html("");
	
	if(mode == 'gav'){
		$.ajax({
			type: 'POST',
			url: siteURL+'/control/getDispoList.php',
			success: function(msg){
				console.log("Mess code : "+msg["code"]);
				//console.log(msg["content"]);
				html += '<div class="compteurElem" style="background: #9dcfe7; font-weight:bold;"><div class="avocat" style="text-align:center;">INTERVENANTS</div><div class="jour">Compteur</div></div>';
				if(msg["code"] == "ok"){
					for(var i=0; i < msg["content"].length; i++ ){
						html += '<div class="compteurElem"><div class="avocat">'+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+'</div>';
						html += '<div class="jour">'+msg["content"][i]["compteur"]+'</div></div>';
					}
					$("#loader").css("display", "none");
					elem.append(html);
				}else{
					message("errorDispos", msg["content"]);
				}
			},
			error: function(msg){
				console.log("ERROR MESSAGE : "+msg["content"]);
				console.log(msg);
				message("errorDispos", msg["content"]);
			}
		});
	}else{
		$.ajax({
			type: 'POST',
			url: siteURL+'/control/getCompteurList.php',
			success: function(msg){
				console.log("Mess code : "+msg["code"]);
				console.log(msg["content"]);
				html += '<div class="compteurElemPP" style="background: #9dcfe7; font-weight:bold;"><div class="avocat" style="text-align:center;">INTERVENANTS</div><div class="jour">Majeurs</div><div class="jour">Mineurs</div><div class="jour">Etrangers</div><div class="jour">H.O.</div><div class="jour">Total</div></div>';
				if(msg["code"] == "ok"){
					for(var i=0; i < msg["content"].length; i++ ){
						if(msg["content"][i]["user_tel2"] != ''){
							var tel2 = " / "+msg["content"][i]["user_tel2"];
						}else{
							var tel2 = "";
						}
						html += '<div class="compteurElemPP"><div class="avocat"><b>'+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+'</b><br>'+msg["content"][i]["user_tel1"]+tel2+'</div>';
						if(msg["content"][i]["user_compt_1"] != 0){
							html += '<div class="jour"><b>'+msg["content"][i]["user_compt_1"]+'</b></div>';
						}else{
							html += '<div class="jour"> </div>';
						}
						if(msg["content"][i]["user_compt_2"] != 0){
							html += '<div class="jour"><b>'+msg["content"][i]["user_compt_2"]+'</b></div>';
						}else{
							html += '<div class="jour"> </div>';
						}
						if(msg["content"][i]["user_compt_3"] != 0){
							html += '<div class="jour"><b>'+msg["content"][i]["user_compt_3"]+'</b></div>';
						}else{
							html += '<div class="jour"> </div>';
						}
						if(msg["content"][i]["user_compt_4"] != 0){
							html += '<div class="jour"><b>'+msg["content"][i]["user_compt_4"]+'</b></div>';
						}else{
							html += '<div class="jour"> </div>';
						}
						html += '<div class="jour">'+msg["content"][i]["user_compt_tot"]+'</div></div>';
					}
					$("#loader").css("display", "none");
					elem.append(html);
				}else{
					$("#loader").css("display", "none");
					message("errorDispos", msg["content"]);
				}
			},
			error: function(msg){
				$("#loader").css("display", "none");
				console.log("ERROR MESSAGE : "+msg["content"]);
				console.log(msg);
				message("errorDispos", msg["content"]);
			}
		});
	}
}

function loadDateCompteur(el, mode)
{
	console.log("--- loadDateCompteur('"+el+"','"+mode+"') ---");
	message("errorDispos", "");
	message("confirmDispos", "");
	
	var elem = $(el);
	elem.html("");
	
	var data={};
	data["sent"] = 1;
	data["mode"] = mode;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getDateCompteur.php',
		data: { data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			//console.log(msg["content"]);
			if(msg["code"] == "ok"){
				//On formate la date comme il faut.
				date = msg["content"][0]["date"].split('-');
				elem.html("Depuis le "+date[2]+"-"+date[1]+"-"+date[0]);
			}else{
				message("errorDispos", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorDispos", msg["content"]);
		}
	});
}

function updateDateCompteur(date, mode)
{
	console.log("--- updateDateCompteur('"+date+"','"+mode+"') ---");
	message("errorCompteurDate", "");
	message("confirmCompteurDate", "");
	
	var data={};
	data["sent"] = 1;
	data["date"] = date;
	data["mode"] = mode;
	
	$("#loader").css("display", "block");
	
	if(date == ""){
		message("errorCompteurDate", "Veillez choisir une date");
		return false;
	}
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/updateDateCompteur.php',
		data: { data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				loadDateCompteur('#dateCompteur',mode);
				loadCompteur('#dispoList', mode);
				$("#loader").css("display", "none");
			}else{
				message("errorCompteurDate", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorCompteurDate", msg["content"]);
		}
	});
}

function updateDispos()
{
	console.log("--- updateDispos('') ---");
	message("errorDispos", "");
	message("confirmDispos", "");
	
	var idList = $('#idList').val();
	idList = idList.split('-');
	
	var data={};
	data["sent"] = 1;
	data["infos"] = [];
	
	for(var i=0; i < idList.length; i++){
		var userDispos = [];
		userDispos[0] = idList[i];
		userDispos[1] = transBoolean($('#'+idList[i]+'_lun').prop("checked"));
		userDispos[2] = transBoolean($('#'+idList[i]+'_mar').prop("checked"));
		userDispos[3] = transBoolean($('#'+idList[i]+'_mer').prop("checked"));
		userDispos[4] = transBoolean($('#'+idList[i]+'_jeu').prop("checked"));
		userDispos[5] = transBoolean($('#'+idList[i]+'_ven').prop("checked"));
		userDispos[6] = transBoolean($('#'+idList[i]+'_sam').prop("checked"));
		userDispos[7] = transBoolean($('#'+idList[i]+'_dim').prop("checked"));
		data["infos"].push(userDispos);
	}

	data["infos"] = JSON.stringify(data["infos"]);

	$.ajax({
		type: 'POST',
		dataType: "json",
		url: siteURL+'/control/updateDispos.php',
		data: { data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				message("confirmDispos", msg["content"]);
			}else{
				message("errorDispos", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- MON PLANNING --------------------------------------------------------------------------------------------

function loadMonPlanning(el, userId, admin)
{
	console.log("--- loadMonPlanning('"+el+"', "+userId+", '"+admin+"') ---");
	message("errorPlanning", "");
	message("confirmPlanning", "");
	var elem = $(el);
	
	$("#printLine").css('display', 'none');
	
	elem.html('');
	
	var couleurs = [];
	couleurs["Coordinateur"] = "#52a4cb";
	couleurs["Intervenant"] = "";
	couleurs["Observateur"] = "";
	couleurs["Majeurs"] = "#993767";
	couleurs["Mineurs"] = "#b57a4d";
	couleurs["Etrangers"] = "#447c69";
	couleurs["SSC"] = "#e16552";
	couleurs["GAV"] = "#8a0f4b";
	
	
	
	var data={};
	data["sent"] = 1;
	data["userId"] = userId;
	data["admin"] = admin;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getMonPlanning.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				var html = '<div class="monPlanningElem" style="background: #235f7b;"><div class="date"><b>Date</b></div><div class="perm"><b>Permanence</b></div><div class="role"><b>Rôle</b></div></div>';
				for(var i=0; i < msg["content"].length; i++){
					if(msg["content"][i][3] == "Coordinateur"){
						var couleur = couleurs["Coordinateur"];
					}else{
						var couleur = couleurs[msg["content"][i][2]];
					}
					if(msg["content"][i][4] == 1){
						var separateur = 'border-top: 2px solid black;';
					}else{
						var separateur = '';
					}
					html += '<div class="monPlanningElem" style="background: '+couleur+'; '+separateur+'"><div class="date">'+msg["content"][i][1]+'</div><div class="perm">'+msg["content"][i][2]+'</div><div class="role">'+msg["content"][i][3]+'</div></div>';
				}
				elem.append(html);
				$("#printLine").css('display', 'block');
			}else{
				$("#printLine").css('display', 'none');
				message("errorPlanning", msg["content"]);
			}
		},
		error: function(msg){
			$("#printLine").css('display', 'none');
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorPlanning", msg["content"]);
		}
	});
}

// -------------------------------------------------------------------------------------------- PERMUTATIONS -----------------------------------------------------------------------------------------------------

function loadPermutations(el)
{
	console.log("--- loadPermutations('"+el+"') ---");
	message("errorPermutation", "");
	message("confirmPermutation", "");
	
	var perm = [];
	perm[1] = "Majeurs";
	perm[2] = "Mineurs";
	perm[3] = "Etrangers";
	perm[4] = "H.O.";
	perm[5] = "GAV";
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	elem.html('');
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getPermutationList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				for(var i=0; i < msg["content"].length; i++){
					var html = '<div class="listPermutationsElem">';
					html += '<div>Me '+msg["content"][i]["avocat1"]+'</div>';
					html += '<div>'+perm[msg["content"][i]["avocat1Perm"]]+'<br>'+msg["content"][i]["avocat1Date"]+'</div>';
					html += '<div>échange avec</div>';
					html += '<div>Me '+msg["content"][i]["avocat2"]+'</div>';
					html += '<div>'+perm[msg["content"][i]["avocat2Perm"]]+'<br>'+msg["content"][i]["avocat2Date"]+'</div>';
					html += '<div><button onClick="processPermutation('+msg["content"][i]["perm_id"]+',1);">Valider</button></div>';
					html += '<div><button onClick="processPermutation('+msg["content"][i]["perm_id"]+',0);">Refuser</button></div>';
					html += '</div>';  
					elem.append(html);
				}
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function processPermutation(permId, valide)
{
	console.log("--- processPermutation("+permId+","+valide+") ---");
	message("errorPermutation", "");
	message("confirmPermutation", "");
	
	var data={};
	data["sent"] = 1;
	data["permId"] = permId;
	data["valide"] = valide;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/processPermutation.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmPermutation", msg["content"]);
				loadPermutations('#listPermutations');
			}else{
				message("errorPermutation", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddNote", "Pas de connexion au serveur");
		}
	});
}

function loadAvocatList(el)
{
	console.log("--- loadAvocatList('"+el+"') ---");
	message("errorPermutation", "");
	message("confirmPermutation", "");
	
	$("#loader").css("display", "block");	
	var elem = $(el);
	
	elem.find('option').remove().end();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getAvocatList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '<option value="none">--- Choisir ---</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += '<option value="'+msg["content"][i]["user_id"]+'">'+msg["content"][i]["user_nom"]+' '+msg["content"][i]["user_prenom"]+'</option>';
				}
				elem.append(html);
				$("#loader").css("display", "none");
			}else{
				message("errorAddUserTemp", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorAddUserTemp", msg["content"]);
		}
	});
}

function submitPermutation(avocat)
{
	console.log("--- submitPermutation('"+avocat+"') ---");
	message("errorPermutation", "");
	message("confirmPermutation", "");
	
	console.log("Avocat : "+avocat);
	
	var choix = $('input[name=choixPerm]:checked').val();
	
	if(choix == "choixGAV"){
		var permType = 5;
		if($('#dateHidden21').val() == ''){
			message("errorPermutation", "Merci de choisir la date de votre permanence");
			return false;
		}
		if($('#avoGAVCible').val() == 'none'){
			message("errorPermutation", "Merci de choisir l'avocat cible");
			return false;
		}
		if($('#dateHidden22').val() == ''){
			message("errorPermutation", "Merci de choisir la date de permanence de l'avocat cible");
			return false;
		}
		var dateAvocat = $('#dateHidden21').val();
		var permAvocat = 5;
		var avocatCible = $('#avoGAVCible').val();
		var dateAvocatCible = $('#dateHidden22').val();
		var permAvocatCible = 5;
	}else if(choix == "choixPP"){
		var permType = 1;
		if($('#dateHidden11').val() == ''){
			message("errorPermutation", "Merci de choisir la date de votre permanence");
			return false;
		}
		if($('#avoCible').val() == 'none'){
			message("errorPermutation", "Merci de choisir l'avocat cible");
			return false;
		}
		if($('#dateHidden12').val() == ''){
			message("errorPermutation", "Merci de choisir la date de permanence de l'avocat cible");
			return false;
		}
		var dateAvocat = $('#dateHidden11').val();
		var permAvocat = $('#perm').val();
		var avocatCible = $('#avoCible').val();
		var dateAvocatCible = $('#dateHidden12').val();
		var permAvocatCible = $('#permCible').val();;
	}else{
		message("errorPermutation", "Merci de choisir la permanence concernée");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["permType"] = permType;
	data["avocat"] = avocat;
	data["dateAvocat"] = dateAvocat;
	data["permAvocat"] = permAvocat;
	data["avocatCible"] = avocatCible;
	data["dateAvocatCible"] = dateAvocatCible;
	data["permAvocatCible"] = permAvocatCible;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/submitPermutation.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmPermutation", msg["content"]);
				$('#datepicker').val("");
				$('#dateHidden').val("");
				$('#infoText').val("");
				//loadNotes('#listNotes');
			}else{
				message("errorPermutation", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddNote", "Pas de connexion au serveur");
		}
	});	
}

// --------------------------------------------------------------------------------------------- NOTES / INFOS DU JOUR -------------------------------------------------------------------------------------------

function addNote()
{
	console.log("--- addNote() ---");
	message("errorAddNote", "");
	message("confirmAddNote", "");
	
	if($('#dateHidden').val() == ""){
		message("errorAddNote", "Merci de saisir une date");
		return false;
	}
	
	if($('#infoText').val() == ""){
		message("errorAddNote", "Merci de saisir une note/info");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["date"] = $('#dateHidden').val();
	data["note"] = $('#infoText').val().trim();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addNote.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			//console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmAddNote", "Info ajoutée");
				$('#datepicker').val("");
				$('#dateHidden').val("");
				$('#infoText').val("");
				loadNotes('#listNotes');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddNote", "Pas de connexion au serveur");
		}
	});
}

function deleteNote()
{
	console.log("--- deleteNote() ---");
	message("errorDeleteNote", "");
	message("confirmDeleteNote", "");
	
	if($('#listNotes').val() == "none"){
		message("errorDeleteNote", "Merci de choisir une note");
		return false;
	}
	
	var data={};
	data["noteId"] = $('#listNotes').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deleteNote.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmDeleteNote", "Note/Info supprimée");
				loadNotes('#listNotes');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorDeleteNote", "Pas de connexion au serveur");
		}
	});
}

function loadNotes(el)
{
	console.log("--- deleteNote() ---");
	message("errorDeleteNote", "");
	message("confirmDeleteNote", "");
	
	var elem = $(el);
	elem.html('');
	
	elem.find('option').remove().end();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getNoteList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			if(msg["code"] == "ok"){
				var html = '<option value="none">--- Choisir ---</option>';
				for(var i=0; i < msg["content"].length; i++){
					html += '<option value="'+msg["content"][i]["note_id"]+'">'+msg["content"][i]["note_date"]+' - '+msg["content"][i]["note_text"].substring(0,30)+'...</option>';
				}
				elem.append(html);
			}else{
				message("errorDeleteNote", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			console.log(msg);
			message("errorDeleteNote", msg["content"]);
		}
	});
}

// --------------------------------------------------------------------------------------------- LISTES DE RENFORTS ----------------------------------------------------------------------------------------------

function listRenforts(el)
{
	console.log("--- listRenforts('"+el+"') ---");
	message("errorListe", "");
	message("confirmListe", "");
	
	var elem = $(el);
	elem.html('');
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getRenfortsList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				var htmlpp = '<div class="subListRenforts"><div style="font-size: 20px; padding-bottom: 5px;"><b>Renforts permanence palais</b></div>';
				var htmlgav = '<div class="subListRenforts"><div style="font-size: 20px; padding-bottom: 5px;"><b>Renforts GAV</b></div>';
				for(var i=0; i<msg["content"].length; i++){
					if(msg["content"][i][3] == 'gav'){
						htmlgav += '<div><a href="'+msg["content"][i][2]+'" target="_blank">'+msg["content"][i][1]+'</a></div>';
					}else{
						htmlpp += '<div><a href="'+msg["content"][i][2]+'" target="_blank">'+msg["content"][i][1]+'</a></div>';
					}
				}
				htmlpp += '</div>';
				htmlgav += '</div>';
				var html = htmlpp+htmlgav;
				elem.append(html);
			}else{
				message("errorListe", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorListe", "Pas de connexion au serveur");
		}
	});
}

function listRenfortsAdmin(el)
{
	console.log("--- listRenfortsAdmin('"+el+"') ---");
	message("errorListe", "");
	message("confirmListe", "");
	
	var elem = $(el);
	elem.html('');
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/getRenfortsList.php',
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log(msg["content"]);
			if(msg["code"] == "ok"){
				//message("confirmListe", "Liste ajoutée");
				var html = "";
				for(var i=0; i<msg["content"].length; i++){
					html += '<div class="elemRenfort">';
					html += '<div>'+msg["content"][i][1]+'</div>';
					html += '<div><button title="Supprimer" onclick="deleteRenfort('+msg["content"][i][0]+');"><img src="images/icons/icon-delete.png"></button></div>';
					html += '</div>';
				}
				elem.append(html);
			}else{
				message("errorListe", msg["content"]);
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorListe", "Pas de connexion au serveur");
		}
	});
}

function deleteRenfort(renfId)
{
	console.log("--- deleteRenfort("+renfId+") ---");
	message("errorAddListe", "");
	message("confirmAddListe", "");
	
	var data={};
	data["renfId"] = renfId;
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/deleteRenfort.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				listRenfortsAdmin('#listRenforts');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddListe", "Pas de connexion au serveur");
		}
	});
}

function addListeRenf()
{
	console.log("--- addListeRenf() ---");
	message("errorAddListe", "");
	message("confirmAddListe", "");
	
	if($('#listeTitle').val() == ""){
		message("errorAddListe", "Merci de saisir un titre");
		return false;
	}
	
	if($('#listeLien').val() == ""){
		message("errorAddListe", "Merci de saisir un lien");
		return false;
	}
	
	var data={};
	data["sent"] = 1;
	data["titre"] = $('#listeTitle').val().trim();
	data["lien"] = $('#listeLien').val().trim();
	data["perm"] = $('#listePerm').val();
	
	$.ajax({
		type: 'POST',
		url: siteURL+'/control/addRenfort.php',
		data: { 'data' : data },
		success: function(msg){
			console.log("Mess code : "+msg["code"]);
			console.log("Mess content : "+msg["content"]);
			if(msg["code"] == "ok"){
				message("confirmAddListe", "Liste ajoutée");
				$('#listeTitle').val("");
				$('#listeLien').val("");
				listRenfortsAdmin('#listRenforts');
			}
		},
		error: function(msg){
			console.log("ERROR MESSAGE : "+msg["content"]);
			message("errorAddListe", "Pas de connexion au serveur");
		}
	});
}

// --------------------------------------------------------------------------------------------- IMPRESSIONS ----------------------------------------------------------------------------------------------

function loadPrintPage(mode)
{
	console.log("--- loadPrintPage("+mode+") ---");
	var url = siteURL+'/print.php?mode='+mode+'&mois='+$('#moisHidden').val()+'&annee='+$('#anneeHidden').val();
	
	window.open(url, 'test', "height=700,width=800");
}

function loadPrintPageJour()
{
	console.log("--- loadPrintPageJour() ---");
	var url = siteURL+'/print.php?mode=jourpp&jour='+$('#currentDateHidden').val();
	
	window.open(url, 'test', "height=700,width=800");
}

function loadPrintPagePerso()
{
	console.log("--- loadPrintPagePerso() ---");
	var url = siteURL+'/print.php?mode=perso';
	
	window.open(url, 'test', "height=700,width=800");
}

// -------------------------------------------------------------------------------------------- CHARGEMENT DE LA PAGE --------------------------------------------------------------------------------------------

// Au chargement de la page.
$( document ).ready(function() {
	
	// Init dialog
	$.ui.dialog.prototype._focusTabbable = function(){};
	
	$( "#dialog" ).dialog({
	  autoOpen: false,
	  modal: true,
	  position: { my: "center top+200", at: "center top", of: window },
	  show: {
		effect: "fade",
		duration: 250
	  },
	  hide: {
		effect: "fade",
		duration: 250
	  }
	});
});