<style>
/*
.ui-autocomplete {
	width: 100%;
	max-height: 100px;
	overflow-y: auto;
	overflow-x: hidden;
}
* html .ui-autocomplete {
	height: 100px;
}
.ui-autocomplete-loading {
	background: white url("../images/ajax_loader.gif") no-repeat 99%;
	background-size: 20px 20px;
}
*/
</style>
<script>
jQuery.ui.autocomplete.prototype._resizeMenu = function () {
  var ul = this.menu.element;
  ul.outerWidth(this.element.outerWidth());
}

$( function() {
    function split( val ) {
      return val.split( /;\s*/ );
    }
    function extractLast( term ) {
      return split( term ).pop();
    }
 
    $("#keySearch1, #keySearch2")
      // don't navigate away from the field on tab when selecting an item
      .on( "keydown", function( event ) {
        if ( event.keyCode === $.ui.keyCode.TAB &&
            $( this ).autocomplete( "instance" ).menu.active ) {
          event.preventDefault();
        }
      })
      .autocomplete({
        source: function( request, response ) {
          $.getJSON( "../control/search.php", {
            term: extractLast( request.term )
          }, response );
        },
        search: function() {
          // custom minLength
          var term = extractLast( this.value );
          if ( term.length < 2 ) {
            return false;
          }
        },
        focus: function() {
          // prevent value inserted on focus
          return false;
        },
        select: function( event, ui ) {
          var terms = split( this.value );
          // remove the current input
          terms.pop();
          // add the selected item
          terms.push( ui.item.value );
          // add placeholder to get the comma-and-space at the end
          terms.push( "" );
          this.value = terms.join( "; " );
          return false;
        }
      });
	}
);  
</script>	