<?php

function generateRetrivalLink($email) {
    global $cnx;
    $date = date("Y-m-d H:i:s");
    $chaine = md5($email . $date);
    $sql = "INSERT INTO barreau_liens_recup (lien_content, lien_valide, lien_email, lien_date) VALUES ('" . $chaine . "',1, '" . $email . "',CURDATE())";
    if ($result_query = $cnx->query($sql)) {
        return $chaine;
    }
}
function getCategorieDoc() {
    global $cnx;
    $retour = [];
    $sql = "SELECT c1.cat_doc_id, c1.cat_doc_label, c2.cat_doc_id, c2.cat_doc_label FROM barreau_cat_doc c1 LEFT JOIN barreau_cat_doc c2 ON c2.cat_doc_parent = c1.cat_doc_id WHERE c1.cat_doc_parent = 0 ORDER BY c1.cat_doc_ordre, c1.cat_doc_id, c2.cat_doc_id";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getCatById($catId) {
    global $cnx;
    $retour = [];
    $sql = "SELECT cat_doc_label FROM barreau_cat_doc WHERE cat_doc_id = " . $catId;
    $result_query = $cnx->query($sql);
    if ($row = $result_query->fetch()) {
        return $row[0];
    } else {
        return false;
    }
}

function addCat($catName, $catParentName) {
    global $cnx;
    $retour = [];
    if ($catParentName == "none") {
        $catParentName = 0;
    }
    $sql = "SELECT MAX(cat_doc_ordre)+1 as max FROM barreau_cat_doc";
    $result_query = $cnx->query($sql);
    if ($row = $result_query->fetch()) {
        $max = $row["max"];
    } else {
        return false;
    }
    $sql = "INSERT INTO barreau_cat_doc (cat_doc_label, cat_doc_parent, cat_doc_ordre) values ('" . addslashes($catName) . "'," . $catParentName . "," . $max . ")";
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function editCat($catId, $catName) {
    global $cnx;
    $retour = [];
    $sql = "UPDATE barreau_cat_doc SET ";
    $sql.= "cat_doc_label = '" . addslashes($catName) . "' ";
    $sql.= "WHERE cat_doc_id = " . $catId;
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function supprCat($catId) {
    global $cnx;
    $retour = [];
    $sql = "DELETE FROM barreau_cat_doc WHERE cat_doc_id = " . $catId;
    if ($result_query = $cnx->query($sql)) {
        $sql2 = "DELETE FROM barreau_cat_doc WHERE cat_doc_parent = " . $catId;
        if ($result_query = $cnx->query($sql2)) {
            $retour = "OK";
        }
    }
    return $retour;
}

function getDocuments() {
    global $cnx;
    $retour = [];
    $sql = "SELECT doc_id, doc_cat, doc_file, doc_name, doc_ext, doc_desc FROM barreau_doc ORDER BY doc_id DESC";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getDocumentByCatId($catId) {
    global $cnx;
    $retour = [];
    if ($catId != "none") {
        $where = " WHERE doc_cat = " . $catId;
    } else {
        $where = "";
    }
    $sql = "SELECT cat_doc_parent FROM barreau_cat_doc WHERE cat_doc_id=" . $catId;
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    if ($row["cat_doc_parent"] != 0) {
        $sql = "SELECT doc_id, doc_cat, doc_file, doc_name, doc_ext, doc_desc FROM barreau_doc" . $where . " ORDER BY doc_id DESC";
        $result_query = $cnx->query($sql);
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    } else {
        $sql = "SELECT doc_id, doc_cat, doc_file, doc_name, doc_ext, doc_desc FROM barreau_doc d LEFT JOIN barreau_cat_doc c ON d.doc_cat=c.cat_doc_id WHERE c.cat_doc_id = " . $catId . " OR c.cat_doc_parent = " . $catId . " ORDER BY doc_id DESC";
        $result_query = $cnx->query($sql);
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getDocumentsHome() {
    global $cnx;
    $retour = [];
    $sql = "SELECT doc_id, doc_file, doc_name, doc_ext, doc_desc FROM barreau_doc_home ORDER BY doc_id DESC";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function addDocument($cat, $file, $name, $ext, $desc) {
    global $cnx;
    $retour = [];
    $sql = "INSERT INTO barreau_doc (doc_cat, doc_file, doc_name, doc_ext, doc_desc) values (" . $cat . ",'" . $file . "', '" . $name . "', '" . $ext . "', '" . $desc . "')";
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function addDocumentHome($file, $name, $ext, $desc) {
    global $cnx;
    $retour = [];
    $sql = "INSERT INTO barreau_doc_home (doc_file, doc_name, doc_ext, doc_desc) values ('" . $file . "', '" . $name . "', '" . $ext . "', '" . $desc . "')";
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function supprDoc($docFile) {
    global $cnx;
    $retour = [];
    $docFile = explode(".", $docFile);
    $docFile = $docFile[0];
    $sql = "DELETE FROM barreau_doc WHERE doc_file = '" . $docFile . "'";
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function supprDocHome($docFile) {
    global $cnx;
    $retour = false;
    $docFile = explode(".", $docFile);
    $docFile = $docFile[0];
    $sql = "SELECT doc_id FROM barreau_doc_home WHERE doc_file = '" . $docFile . "'";
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    $docId = $row[0];
    $sql = "DELETE FROM barreau_doc_home WHERE doc_id = '" . $docId . "'";
    if ($result_query = $cnx->query($sql)) {
        $sql = "UPDATE barreau_infos_home SET info_doc_id = -1 WHERE info_doc_id = " . $docId;
        if ($result_query = $cnx->query($sql)) {
            return true;
        } else {
            return false;
        }
    }
}

function getDocHomeDescById($docHomeId) {
    global $cnx;
    $retour = [];
    $sql = "SELECT doc_desc FROM  barreau_doc_home WHERE doc_id=" . $docHomeId;
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    array_push($retour, $row);
    return $retour;
}

function getDocDescById($docId) {
    global $cnx;
    $retour = [];
    $sql = "SELECT doc_desc FROM  barreau_doc WHERE doc_id=" . $docId;
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    array_push($retour, $row);
    return $retour;
}

function editDocHomeDesc($docHomeId, $docHomeDesc) {
    global $cnx;
    $retour = "";
    $sql = "UPDATE barreau_doc_home SET ";
    $sql.= "doc_desc = '" . addslashes($docHomeDesc) . "' ";
    $sql.= "WHERE doc_id = " . $docHomeId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function editDocDesc($docId, $docDesc) {
    global $cnx;
    $retour = "";
    $sql = "UPDATE barreau_doc SET ";
    $sql.= "doc_desc = '" . addslashes($docDesc) . "' ";
    $sql.= "WHERE doc_id = " . $docId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function getInfoHome() {
    global $cnx;
    $retour = [];
    $sql = "SELECT info_id, info_titre FROM barreau_infos_home ORDER BY info_id DESC";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getInfoHomeById($infoId) {
    global $cnx;
    $retour = [];
    $sql = "SELECT info_id, info_doc_id, info_titre, info_text, info_date FROM barreau_infos_home WHERE info_id=" . $infoId;
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    array_push($retour, $row);
    return $retour;
}

function addInfo($infoTitre, $infoTexte, $infoFile) {
    global $cnx;
    $retour = false;
    if ($infoFile == "none") {
        $infoFile = - 1;
    }
    $sql = "INSERT INTO barreau_infos_home (info_doc_id, info_titre, info_text, info_date) values (" . $infoFile . ", '" . addslashes($infoTitre) . "', '" . addslashes($infoTexte) . "', CURRENT_TIMESTAMP())";
    if ($result_query = $cnx->query($sql)) {
        $retour = "OK";
    }
    return $retour;
}

function editInfo($infoId, $infoTitle, $infoText, $infoFile) {
    global $cnx;
    $retour = false;
    if ($infoFile == "none") {
        $infoFile = - 1;
    }
    $sql = "UPDATE barreau_infos_home SET ";
    $sql.= "info_doc_id = " . $infoFile . ", ";
    $sql.= "info_titre = '" . addslashes($infoTitle) . "', ";
    $sql.= "info_text = '" . addslashes($infoText) . "', ";
    $sql.= "info_date = CURRENT_TIMESTAMP() ";
    $sql.= "WHERE info_id = " . $infoId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function supprInfo($infoId) {
    global $cnx;
    $retour = false;
    $sql = "DELETE FROM barreau_infos_home WHERE info_id = " . $infoId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function getInfoHomeFull($infoId) {
    global $cnx;
    $retour = [];
    if ($infoId == "home") {
        $where = "ORDER BY info_date DESC LIMIT 0,3";
    } else {
        $where = "WHERE info_id=" . $infoId;
    }
    $sql = "SELECT info_id, info_doc_id, info_titre, info_text, info_date, doc_id, doc_file, doc_name, doc_ext, doc_desc FROM barreau_infos_home i LEFT JOIN barreau_doc_home d ON i.info_doc_id = d.doc_id " . $where;
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getInfoHomeTitle($page) {
    global $cnx;
    $retour = [];
    $offset = ($page - 1) * 10;
    $count = 10;
    $sql = "SELECT info_id, info_titre FROM barreau_infos_home ORDER BY info_date DESC LIMIT " . $offset . "," . $count;
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getInfoHomeCount() {
    global $cnx;
    $retour = [];
    $sql = "SELECT count(info_id) FROM barreau_infos_home";
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    array_push($retour, $row);
    return $retour;
}

function recordModule($mode, $start, $end, $mois, $annee) {
    global $cnx;
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "INSERT INTO " . $table . " (mod_start, mod_end, mod_mois, mod_annee) values ('" . $start . "','" . $end . "'," . $mois . "," . $annee . ")";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    }
    return true;
}

function generateModule($mode, $start, $end, $mois, $annee) {
    $begin = new DateTime($start);
    $end = new DateTime($end);
    $end = $end->modify('+1 day');
    $interval = new DateInterval('P1D');
    $daterange = new DatePeriod($begin, $interval, $end);
    $bufferStart = "";
    $bufferEnd = "";
    foreach ($daterange as $date) {
        $jour = $date->format("N");
        if ($mode == "palais") {
            if ($jour == 2 || $jour == 4 || $jour == 6) {
                $bufferStart = $date->format("Y-m-d");
            }
            if ($jour == 3 || $jour == 5 || $jour == 1) {
                $bufferEnd = $date->format("Y-m-d");
                if (!recordModule($mode, $bufferStart, $bufferEnd, $mois, $annee)) {
                    return false;
                }
            }
        } else {
            if ($jour == 1 || $jour == 3 || $jour == 5) {
                $bufferStart = $date->format("Y-m-d");
            }
            if ($jour == 2 || $jour == 4 || $jour == 7) {
                $bufferEnd = $date->format("Y-m-d");
                if (!recordModule($mode, $bufferStart, $bufferEnd, $mois, $annee)) {
                    return false;
                }
            }
        }
    }
    return true;
}

function deleteModules($mois, $annee, $mode) {
    global $cnx;
    $retour = [];
    if ($mode == "gav") {
        $modules = "barreau_modulesGAV";
        $planning = "barreau_planningGAV";
    } else {
        $modules = "barreau_modules";
        $planning = "barreau_planning";
    }
    $sql = "SELECT mod_id, mod_start, mod_end FROM " . $modules . " WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
    $result_query = $cnx->query($sql);
    $rows = $result_query->fetchAll();
    foreach ($rows as $row) {
        $sql = "DELETE FROM " . $planning . " WHERE mod_id = " . $row["mod_id"];
        $result_query = $cnx->query($sql);
        if ($mode == "gav") {
            $sql = "DELETE FROM barreau_planningGAVJour WHERE plan_jour_date >= '" . $row["mod_start"] . "' AND plan_jour_date <=  '" . $row["mod_end"] . "'";
            $result_query = $cnx->query($sql);
        }
    }
    updateCompteur("gav");
    updateCompteur("palais");
    $sql = "DELETE FROM " . $modules . " WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
    $result_query = $cnx->query($sql);
    deletePlanningValide($mois, $annee, $mode);
    return true;
}

function getModules($mode, $nombre) {
    global $cnx;
    $retour = [];
    if ($mode == "gav") {
        $module = "barreau_modulesGAV";
    } else {
        $module = "barreau_modules";
    }
    $sql = "SELECT DISTINCT mod_mois, mod_annee FROM " . $module . " ORDER BY mod_end DESC LIMIT 0," . $nombre;
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($row, returnLitteralMonth($row["mod_mois"]));
        array_push($retour, $row);
    }
    return $retour;
}

function getLastModule($mode) {
    global $cnx;
    $retour = [];
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT mod_mois, mod_annee FROM " . $table . " ORDER BY mod_end DESC LIMIT 0,1";
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    if ($row != null) {
        array_push($retour, $row);
        array_push($retour, returnLitteralMonth($retour[0][0]));
        return $retour;
    } else {
        return "Pas de rsultat";
    }
}

function getLastModules($size, $mode) {
    global $cnx;
    $retour = "";
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT min(mod_start), max(mod_end) FROM " . $table . " ORDER BY mod_end DESC LIMIT 0,1";
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    $end = $row[1];
    if ($end === null) {
        $end = date("Y-m-d");
    }
    $earlier = new DateTime($row[0]);
    $later = new DateTime($end);
    $diff = $later->diff($earlier)->format("%a");
    if ($diff > $size) {
        $start = date('Y-m-d', strtotime('-' . $size . ' days', strtotime($end)));
    } else {
        $start = $row[0];
    }
    $begin = new DateTime($start);
    $end = new DateTime($end);
    $end = $end->modify('+1 day');
    $interval = new DateInterval('P1D');
    $daterange = new DatePeriod($begin, $interval, $end);
    foreach ($daterange as $date) {
        $retour.= "'" . $date->format("Y-m-d") . "', ";
    }
    $retour = substr($retour, 0, -2);
    echo $retour;
}

function getLastMonthYear($size, $mode) {
    global $cnx;
    $retour = "";
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT DISTINCT mod_mois, mod_annee FROM " . $table . " ORDER BY mod_end DESC LIMIT 0," . $size;
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row[0] . "-" . $row[1]);
        $retour.= $row[0] . "-" . $row[1] . ",";
    }
    $retour = substr($retour, 0, -1);
    echo ($retour);
}

function modulesExists($mois, $annee, $mode) {
    global $cnx;
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT COUNT(mod_id) as nb FROM " . $table . " WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if ($row['nb'] > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function moduleExist($date, $mode) {
    global $cnx;
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT COUNT(mod_id) as nb FROM " . $table . " WHERE '" . $date . "' >= mod_start AND '" . $date . "' <= mod_end";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if ($row['nb'] > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function getModuleByDate($date, $mode) {
    global $cnx;
    if ($mode == "gav") {
        $table = "barreau_modulesGAV";
    } else {
        $table = "barreau_modules";
    }
    $sql = "SELECT mod_id, mod_start, mod_end FROM " . $table . " WHERE '" . $date . "' >= mod_start AND '" . $date . "' <= mod_end";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row;
    } else {
        return false;
    }
}

function getUserByCode($code) {
    global $cnx;
    $sql = "SELECT user_id, user_login, user_pwd, user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users WHERE user_code = " . $code;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row;
    }
}

function getUserById($userId) {
    global $cnx;
    $sql = "SELECT user_id, user_login, user_pwd, user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users WHERE user_id = " . $userId;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row;
    }
}

function updateUserLastConnect($uId) {
    global $cnx;
    $sql = "UPDATE barreau_users SET ";
    $sql.= "user_last_connect = NOW()";
    $sql.= " WHERE user_id=" . $uId;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function checkUserByCode($code, $mode) {
    global $cnx;
    if ($mode == "temp") {
        $table = "barreau_users_temp";
    } else {
        $table = "barreau_users";
    }
    $retour = "";
    if ($code != 0) {
        $sql = "SELECT count(user_code) FROM " . $table . " WHERE user_code=" . $code;
        if ($result_query = $cnx->query($sql)) {
            $row = $result_query->fetch();
            if ($row[0] > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function ajoutUser($user_login, $user_pwd, $user_prenom, $user_nom, $user_email, $user_code, $user_tel1, $user_tel2, $user_tel3, $user_tel4, $user_email_perso) {
    global $cnx;
    if (!checkUserByCode($user_code, "normal")) {
        $sql = "INSERT INTO barreau_users (user_login, user_pwd, user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso, user_priv_id, user_last_connect) values ('" . addslashes($user_login) . "','" . md5($user_pwd) . "','" . addslashes($user_prenom) . "','" . addslashes($user_nom) . "','" . $user_email . "'," . $user_code . ",'" . $user_tel1 . "','" . $user_tel2 . "','" . $user_tel3 . "','" . $user_tel4 . "','" . $user_email_perso . "',2,NOW())";
        if (!$result_query = $cnx->query($sql)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function deleteUser($uId) {
    global $cnx;
    return true;
}
function editUser($user_id, $user_login, $user_pwd, $user_prenom, $user_nom, $user_email, $user_code, $user_tel1, $user_tel2, $user_tel3, $user_tel4, $user_email_perso, $user_actif) {
    global $cnx;
    $sql = "UPDATE barreau_users SET ";
    $sql.= "user_login = '" . addslashes($user_login) . "', ";
    if ($user_pwd != "noChange") {
        $sql.= "user_pwd = '" . md5($user_pwd) . "', ";
    }
    $sql.= "user_prenom = '" . addslashes($user_prenom) . "', ";
    $sql.= "user_nom = '" . addslashes($user_nom) . "', ";
    $sql.= "user_email = '" . addslashes($user_email) . "', ";
    $sql.= "user_code = '" . addslashes($user_code) . "', ";
    $sql.= "user_actif = " . addslashes($user_actif) . ", ";
    $sql.= "user_tel1 = '" . addslashes($user_tel1) . "', ";
    $sql.= "user_tel2 = '" . addslashes($user_tel2) . "', ";
    $sql.= "user_tel3 = '" . addslashes($user_tel3) . "', ";
    $sql.= "user_tel4 = '" . addslashes($user_tel4) . "', ";
    $sql.= "user_email_perso = '" . addslashes($user_email_perso) . "' ";
    $sql.= "WHERE user_id = " . $user_id;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function getUserTemp() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users_temp";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getLoginList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_login FROM barreau_users";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getCodeList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_code FROM barreau_users";
    $result_query = $cnx->query($sql);
    while ($row = $result_query->fetch()) {
        array_push($retour, $row);
    }
    return $retour;
}

function getUserList($mode, $valeur) {
    global $cnx;
    $retour = [];
    if ($mode == "nom") {
        $filtre = " WHERE user_nom LIKE '%" . $valeur . "%'";
    } else if ($mode == "email") {
        $filtre = " WHERE user_email LIKE '%" . $valeur . "%'";
    } else if ($mode == "code") {
        $filtre = " WHERE user_code LIKE '%" . $valeur . "%'";
    } else {
        $filtre = " WHERE user_id=" . $valeur;
    }
    if ($valeur == "avocat") {
        $filtre = " WHERE user_code <> 0";
    }
    if ($valeur == "tous") {
        $filtre = "";
    }
    $sql = "SELECT user_id, user_login, user_prenom, user_nom, user_email, user_code, user_actif, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users" . $filtre . " ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return $sql;
    }
}

function getAvocatList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_id, user_login, user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users WHERE user_code <> 0  AND user_actif = 1 ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return $sql;
    }
}

function userTransfer($log, $pwd, $code, $mail) {
    global $cnx;
    $retour = false;
    $sql = "SELECT user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users_temp WHERE user_code=" . $code;
    $result_query = $cnx->query($sql);
    if ($row = $result_query->fetch()) {
        if (ajoutUser($log, $pwd, $row['user_prenom'], $row['user_nom'], $row['user_email'], $row['user_code'], $row['user_tel1'], $row['user_tel2'], $row['user_tel3'], $row['user_tel4'], $row['user_email_perso'])) {
            majGavDispo();
            $sql = "DELETE FROM barreau_users_temp WHERE user_code=" . $code;
            if ($result_query = $cnx->query($sql)) {
                if ($row['user_email_perso'] != $row['user_email']) {
                    $dest = $row['user_email'] . "," . $row['user_email_perso'];
                } else {
                    $dest = $row['user_email'];
                }
                if ($mail == 1) {
                    if (sendInfoMail($dest, $log, $pwd)) {
                        $retour = true;
                    }
                } else {
                    $retour = true;
                }
            }
        }
    }
    return $retour;
}

function ajoutUserTemp($user_prenom, $user_nom, $user_email, $user_code, $user_tel1, $user_tel2, $user_tel3, $user_tel4, $user_email_perso) {
    global $cnx;
    if (!checkUserByCode($user_code, "normal")) {
        $filtre = array("-", " ", "'");
        $user_login = strtolower(str_replace($filtre, "", $user_prenom) . str_replace($filtre, "", $user_nom));
        $user_pwd = "e4d85ca7303cece48a706a304fc31d79";
        $sql = "INSERT INTO barreau_users_temp (user_prenom, user_nom, user_email, user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso, user_priv_id, user_last_connect) values ('" . addslashes(trim($user_prenom)) . "','" . addslashes(trim($user_nom)) . "','" . $user_email . "'," . $user_code . ",'" . $user_tel1 . "','" . $user_tel2 . "','" . $user_tel3 . "','" . $user_tel4 . "','" . $user_email_perso . "',2,NOW())";
        if (!$result_query = $cnx->query($sql)) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}

function addSnapShot($userCode, $userPerm, $userRole, $userChevro = null) {
    global $cnx;
    $sql = "INSERT INTO barreau_snapshot (user_code, user_perm, user_role, user_chevro) VALUES (" . $userCode . ", " . $userPerm . ", " . $userRole . ", " . $userChevro . ")";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function clearSnapShot($userPerm, $userRole) {
    global $cnx;
    $sql = "DELETE FROM barreau_snapshot WHERE user_perm = " . $userPerm . " AND user_role = " . $userRole;
    if (!$result_query = $cnx->query($sql)) {
        return true;
    } else {
        return true;
    }
}

function addNature($natureCode, $natureLibelle) {
    global $cnx;
    $sql = "INSERT INTO barreau_natures (nature_code, nature_libelle) VALUES (" . $natureCode . ", '" . addslashes(ucfirst(strtolower(trim($natureLibelle)))) . "')";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function getNatureCodes() {
    global $cnx;
    $retour = [];
    $sql = "SELECT nature_code FROM barreau_natures ORDER BY nature_id";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row['nature_code']);
        }
    }
    return $retour;
}

function getDesignationCodes() {
    global $cnx;
    $retour = [];
    $sql = "SELECT des_code FROM barreau_designations ORDER BY des_id";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row['des_code']);
        }
    }
    return $retour;
}

function getDispoCodes() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_code FROM barreau_dispos ORDER BY dispo_id";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row['user_code']);
        }
    }
    return $retour;
}

function majGavDispo() {
    global $cnx;
    $tabRef = getDispoCodes();
    $tabRefSnap = [];
    $sql = "SELECT user_code FROM barreau_snapshot WHERE user_perm = 5 AND user_role <> 1";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($tabRefSnap, $row['user_code']);
            if (!in_array($row['user_code'], $tabRef)) {
                $user = getUserByCode($row['user_code']);
                $sql2 = "INSERT INTO barreau_dispos (user_code, user_id) VALUES (" . $row['user_code'] . "," . $user['user_id'] . ")";
                $result_query2 = $cnx->query($sql2);
            }
        }
    }
    $tabRef = getDispoCodes();
    if (count($tabRefSnap) < count($tabRef)) {
        $tabSuppr = array_diff($tabRef, $tabRefSnap);
        print_r($tabSuppr);
        foreach ($tabSuppr as $suppr) {
            $sql = "DELETE FROM barreau_dispos WHERE user_code = " . $suppr;
            $result_query = $cnx->query($sql);
        }
    }
}

function addDesignation($des_code, $des_affaire, $des_date, $des_heure, $des_avocat, $des_nature, $des_prevPrenom, $des_prevNom, $des_juge) {
    global $cnx;
    //$sql = "INSERT INTO barreau_designations (des_code, des_affaire, des_date, des_heure, des_avocat, des_nature, des_prevPrenom, des_prevNom, des_juge) VALUES (" . $des_code . ", '" . trim($des_affaire) . "', '" . $des_date . "', '" . $des_heure . "', " . $des_avocat . ", " . $des_nature . ", '" . ucfirst(strtolower(trim(addslashes($des_prevPrenom)))) . "', '" . ucfirst(strtolower(trim(addslashes($des_prevNom)))) . "', '" . ucfirst(strtolower(trim(addslashes($des_juge)))) . "')";
	$sql = "INSERT INTO barreau_designations (des_code, des_affaire, des_date, des_heure, des_avocat, des_nature, des_prevPrenom, des_prevNom, des_juge) VALUES (" . $des_code . ", '" . trim($des_affaire) . "', '" . $des_date . "', '" . $des_heure . "', " . $des_avocat . ", " . $des_nature . ", '" . ucfirst(strtolower(trim($des_prevPrenom))) . "', '" . ucfirst(strtolower(trim($des_prevNom))) . "', '" . ucfirst(strtolower(trim($des_juge))) . "')";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function cleanDesignations($date) {
    global $cnx;
    $sql = "DELETE FROM barreau_designations WHERE des_date < '" . $date . "'";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function resetDesignations() {
    global $cnx;
    $sql = "DELETE FROM barreau_designations";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        $sql = "ALTER TABLE barreau_designations AUTO_INCREMENT = 1";
        if (!$result_query = $cnx->query($sql)) {
            return false;
        } else {
            return true;
        }
    }
}

function updateDatabase($file) {
    if ($xlsx = SimpleXLSX::parse($file)) {
        $pages = $xlsx->sheetNames();
        $checkCode = [];
        for ($j = 0;$j < count($pages);$j++) {
            if ($pages[$j] != "Avocats_PP" && $pages[$j] != "Intervenants_SOS" && $pages[$j] != "Natures_PP" && $pages[$j] != "Designations_PP") {
                $i = 0;
                foreach ($xlsx->rows($j) as $elt) {
                    if ($i == 0) {
                    } else {
                        if (in_array($elt[0], $checkCode)) {
                            $debut = "<span style='color: red'>";
                            $fin = "</span><br>";
                        } else {
                            array_push($checkCode, $elt[0]);
                            if (ajoutUserTemp($elt[4], $elt[3], $elt[15], $elt[0], $elt[5], $elt[6], $elt[7], $elt[8], $elt[14])) {
                                $debut = "OK -->";
                            } else {
                                $debut = "NOK -->";
                            }
                        }
                    }
                    $i++;
                }
            }
        }
        $flag = 0;
        for ($i = 0;$i < count($pages);$i++) {
            switch ($pages[$i]) {
                case "Coordinateurs_GAV":
                    $flag = 1;
                    $role = 1;
                    $perm = 5;
                break;
                case "Intervenants_GAV":
                    $flag = 1;
                    $role = 2;
                    $perm = 5;
                break;
                case "Coordinateurs_PP":
                    $flag = 1;
                    $role = 1;
                    $perm = 1;
                break;
                case "Intervenants_PP":
                    $flag = 1;
                    $role = 2;
                    $perm = 1;
                break;
                case "Observateurs_PP":
                    $flag = 1;
                    $role = 3;
                    $perm = 1;
                break;
                case "Intervenants_MIN":
                    $flag = 1;
                    $role = 2;
                    $perm = 2;
                break;
                case "Observateurs_MIN":
                    $flag = 1;
                    $role = 3;
                    $perm = 2;
                break;
                case "Intervenants_ETR":
                    $flag = 1;
                    $role = 2;
                    $perm = 3;
                break;
                case "Observateurs_ETR":
                    $flag = 1;
                    $role = 3;
                    $perm = 3;
                break;
                case "Intervenants_HOF":
                    $flag = 1;
                    $role = 2;
                    $perm = 4;
                break;
                case "Observateurs_HOF":
                    $flag = 1;
                    $role = 3;
                    $perm = 4;
                break;
                case "Natures_PP":
                    $flag = 2;
                break;
            }
            if ($flag == 1) {
                clearSnapShot($perm, $role);
                foreach ($xlsx->rows($i) as $elt) {
                    if ($elt[0] != "AVO_CODE") {
                        if ($elt[16] == "TRUE") {
                            $chevro = 1;
                        } else {
                            $chevro = 0;
                        }
                        if (addSnapShot($elt[0], $perm, $role, $chevro)) {
                        } else {
                        }
                    }
                }
                $flag = 0;
            }
        }
        for ($i = 0;$i < count($pages);$i++) {
            if ($pages[$i] == "Natures_PP") {
                $tabRef = getNatureCodes();
                foreach ($xlsx->rows($i) as $elt) {
                    if ($elt[0] != "NAT_CODE") {
                        if (!in_array($elt[0], $tabRef)) {
                            addNature($elt[0], $elt[1]);
                        }
                    }
                }
            }
        }
        for ($i = 0;$i < count($pages);$i++) {
            if ($pages[$i] == "Designations_PP") {
                resetDesignations();
                $dateLimite = date('Y-m-d', strtotime('-730 days'));
                foreach ($xlsx->rows($i) as $elt) {
                    if ($elt[0] != "DES_CODE") {
                        $date = explode(" ", $elt[3]);
                        $date = $date[0];
                        $heure = explode(" ", $elt[4]);
                        $heure = $heure[1];
                        if ($date > $dateLimite) {
                            addDesignation($elt[0], $elt[1], $date, $heure, $elt[5], $elt[6], $elt[10], $elt[9], $elt[8]);
                        }
                    }
                }
            }
        }
        majGavDispo();
        return true;
    } else {
        return false;
    }
}

function setIndex($perm, $chev, $index) {
    global $cnx;
    $sql = "UPDATE barreau_index SET ";
    $sql.= "index_value=" . $index;
    $sql.= " WHERE index_perm = " . $perm . " AND index_chev = " . $chev;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function getIndex($perm, $chev) {
    global $cnx;
    $sql = "SELECT index_value FROM barreau_index WHERE index_perm = " . $perm . " AND index_chev = " . $chev;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row["index_value"];
    } else {
        return false;
    }
}

function planningExist($mois, $annee, $mode) {
    global $cnx;
    if ($mode == "gav") {
        $module = "barreau_modulesGAV";
        $table = "barreau_planningGAV";
    } else {
        $module = "barreau_modules";
        $table = "barreau_planning";
    }
    $sql = "SELECT COUNT(p.mod_id) as nb FROM " . $table . " p LEFT JOIN " . $module . " m ON p.mod_id=m.mod_id WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if ($row['nb'] > 0) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function getLastPlanning($mode) {
    global $cnx;
    $retour = [];
    if ($mode == "gav") {
        $module = "barreau_modulesGAV";
        $table = "barreau_planningGAV";
    } else {
        $module = "barreau_modules";
        $table = "barreau_planning";
    }
    $sql = "SELECT mod_mois, mod_annee FROM " . $table . " p LEFT JOIN " . $module . " m ON p.mod_id=m.mod_id ORDER BY p.mod_id DESC LIMIT 0,1";
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    if ($row != null) {
        array_push($retour, $row);
        array_push($retour, returnLitteralMonth($retour[0][0]));
        return $retour;
    } else {
        return "Pas de rsultat";
    }
}

function getPlanningList($type, $mode) {
    global $cnx;
    $retour = [];
    if ($type == "pending") {
        $condition = " AND val_valide=0";
    } else {
        $condition = "";
    }
    $sql = "SELECT val_mois as mod_mois, val_annee as mod_annee FROM barreau_planning_valide WHERE val_perm = '" . $mode . "'" . $condition . " ORDER BY val_annee DESC,val_mois DESC";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return false;
    }
}

function getDates($start, $end) {
    $retour = "";
    setlocale(LC_TIME, "fr_FR.UTF-8", "French_France.1252");
    $start = new DateTime($start);
    $interval = new DateInterval('P1D');
    $end = new DateTime($end);
    $end = $end->modify('+1 day');
    $period = new DatePeriod($start, $interval, $end);
    foreach ($period as $key => $value) {
        $retour.= "<a href=\"" . $urlSite . "?page=jourPP&date=" . $value->format('d-m-Y') . "\" class=\"lienJour\">" . strftime("%A %e %B %Y", strtotime($value->format('Y-m-d'))) . "</a><br>";
    }
    $retour = substr($retour, 0, -4);
    return $retour;
}

function getCoordinateurs($mode) {
    global $cnx;
    $retour = [];
    if ($mode == "palais") {
        $perm = 1;
    } else {
        $perm = 5;
    }
    $sql = "SELECT s.user_code, user_id, user_nom, user_prenom FROM barreau_snapshot s LEFT JOIN barreau_users u ON s.user_code = u.user_code WHERE user_perm = " . $perm . " AND user_role = 1 ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return false;
    }
}

function getObservateurs($mode) {
    global $cnx;
    $retour = [];
    switch ($mode) {
        case "majeurs":
            $perm = 1;
        break;
        case "mineurs":
            $perm = 2;
        break;
        case "etrangers":
            $perm = 3;
        break;
        case "ssc":
            $perm = 4;
        break;
    }
    $sql = "SELECT s.user_code, user_id, user_nom, user_prenom FROM barreau_snapshot s LEFT JOIN barreau_users u ON s.user_code = u.user_code WHERE user_perm = " . $perm . " AND user_role = 3 ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return false;
    }
}

function incrementUserCompteur($userId, $perm) {
    global $cnx;
    $sql = "UPDATE barreau_users SET user_compt_" . $perm . " = user_compt_" . $perm . " + 1 WHERE user_id = " . $userId;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function decrementUserCompteur($userId, $perm) {
    global $cnx;
    $sql = "UPDATE barreau_users SET user_compt_" . $perm . " = user_compt_" . $perm . " - 1 WHERE user_id = " . $userId;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function addUserPlanning($userId, $modId, $role, $perm) {
    global $cnx;
    $sql = "INSERT INTO barreau_planning (mod_id,user_id,user_role,user_perm) VALUES (" . $modId . "," . $userId . "," . $role . "," . $perm . ")";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        if ($role == 2) {
            incrementUserCompteur($userId, $perm);
        }
        return true;
    }
}

function addObservateurs($mois, $annee, $coord, $maj_1, $maj_2, $min, $etr, $ssc) {
    global $cnx;
    $retour = "";
    $sql = "SELECT m.mod_id FROM barreau_modules m LEFT JOIN barreau_planning p ON m.mod_id=p.mod_id WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " AND user_role=1 AND user_id=" . $coord;
    if ($result_query = $cnx->query($sql)) {
        $compteur = 0;
        while ($row = $result_query->fetch()) {
            if ($maj_1 != "none") {
                addUserPlanning($maj_1, $row["mod_id"], 3, 1);
            }
            if ($maj_2 != "none") {
                addUserPlanning($maj_2, $row["mod_id"], 3, 1);
            }
            if ($min != "none") {
                addUserPlanning($min, $row["mod_id"], 3, 2);
            }
            if ($etr != "none") {
                addUserPlanning($etr, $row["mod_id"], 3, 3);
            }
            if ($ssc != "none") {
                addUserPlanning($ssc, $row["mod_id"], 3, 4);
            }
            $compteur++;
        }
        if ($compteur == 0) {
            return "Aucun module modifi";
        } else {
            return "Observateur(s) ajout(s)";
        }
    } else {
        return false;
    }
}

function deleteUserPlanning($user_id, $mod_id) {
    global $cnx;
    $sql = "DELETE FROM barreau_planning WHERE user_id = " . $user_id . " AND mod_id = " . $mod_id;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function getModuleType($modId, $mode) {
    global $cnx;
    $type = 0;
    $retour = [];
    if ($mode == "palais") {
        $table = "barreau_modules";
    } else {
        $table = "barreau_modulesGAV";
    }
    $sql = "SELECT mod_start FROM " . $table . " WHERE mod_id = " . $modId;
    $result_query = $cnx->query($sql);
    $row = $result_query->fetch();
    if ($row != null) {
        $retour = $row;
    } else {
    }
    $timestamp = strtotime($retour["mod_start"]);
    $day = date('D', $timestamp);
    switch ($day) {
        case "Sat":
            $type = 3;
        break;
        case "Thu":
            $type = 2;
        break;
        case "Tue":
            $type = 1;
        break;
    }
    return $type;
}

function getInterListOld($role, $perm) {
    global $cnx;
    $retour = [];
    $sql = "SELECT s.user_code, user_id, user_nom, user_prenom, user_chevro FROM barreau_snapshot s LEFT JOIN barreau_users u ON s.user_code = u.user_code WHERE user_perm = " . $perm . " AND user_role = " . $role . " ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        $result_query->closeCursor();
        return $retour;
    } else {
        return false;
    }
}

function extractArray($array, $size, $exclude, $index) {
    $retour = [];
    $compteur = 0;
    $arraySize = count($array);
    if ($index == 0) {
        $run = true;
    } else {
        $run = false;
        $flag = 0;
        foreach ($array as $user) {
            if ($user[0] == $index) {
                $flag = 1;
            }
        }
        if ($flag == 0) {
            $run = true;
        }
    }
    $i = 0;
    while ($compteur < $size && $i < 2 * $arraySize) {
        if ($run && !in_array($array[$i % $arraySize][0], $exclude)) {
            array_push($retour, $array[$i % $arraySize]);
            $compteur++;
        }
        if ($array[$i % $arraySize][0] == $index) {
            $run = true;
        }
        $i++;
    }
    return $retour;
}

function getInter($role, $perm, $chev) {
    global $cnx;
    $retour = [];
    if ($inter = getInterList($role, $perm)) {
        foreach ($inter as $int) {
            if ($int["user_chevro"] == $chev) {
                $valeur = array($int["user_id"], $int["user_nom"]);
                array_push($retour, $valeur);
            }
        }
    }
    return $retour;
}

function getGavExcludeList($start, $end) {
    global $cnx;
    $retour = [];
    $newStart = date('Y-m-d', strtotime('-3 days', strtotime($start)));
    $sql = "SELECT DISTINCT(user_id) as id FROM barreau_planningGAVJour WHERE plan_jour_date >= '" . $newStart . "' AND plan_jour_date <= '" . $end . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row["id"]);
        }
    }
    return $retour;
}

function getInterList($role, $perm) {
    global $cnx;
    $retour = [];
    $sql = "SELECT s.user_code, user_id, user_nom, user_prenom, user_chevro FROM barreau_snapshot s LEFT JOIN barreau_users u ON s.user_code = u.user_code WHERE user_perm = " . $perm . " AND s.user_role = " . $role . " ORDER BY u.user_compt_" . $perm . ", RAND()";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        $result_query->closeCursor();
        return $retour;
    } else {
        return false;
    }
}

function extractInter($list, $excludeList, $nbExtract, $nbChev) {
    $comptChev = 0;
    $comptInter = 0;
    $retour = [];
    foreach ($list as $inter) {
        if (!in_array($inter["user_id"], $excludeList)) {
            if ($comptInter < $nbExtract) {
                if ($comptChev < $nbChev && $comptInter == ($nbExtract - 1)) {
                    if ($inter["user_chevro"] == 1) {
                        $push = [];
                        $push[0] = $inter["user_id"];
                        $push[1] = $inter["user_chevro"];
                        array_push($retour, $push);
                        $comptInter++;
                        if ($inter["user_chevro"] == 1) {
                            $comptChev++;
                        }
                    }
                } else {
                    $push = [];
                    $push[0] = $inter["user_id"];
                    $push[1] = $inter["user_chevro"];
                    array_push($retour, $push);
                    $comptInter++;
                    if ($inter["user_chevro"] == 1) {
                        $comptChev++;
                    }
                }
            } else {
                break;
            }
        }
    }
    array_multisort(array_column($retour, 1), SORT_DESC, $retour);
    return $retour;
}

function genPlanningPP($mois, $annee, $coord_1, $coord_2, $coord_3, $obsMaj_1_1, $obsMaj_2_1, $obsMaj_1_2, $obsMaj_2_2, $obsMaj_1_3, $obsMaj_2_3, $obsMin_1, $obsMin_2, $obsMin_3, $obsEtr_1, $obsEtr_2, $obsEtr_3, $obsSSC_1, $obsSSC_2, $obsSSC_3) {
    global $cnx;
    $retour = [];
    $coord = array($coord_1, $coord_2, $coord_3);
    $obsMaj1 = array($obsMaj_1_1, $obsMaj_1_2, $obsMaj_1_3);
    $obsMaj2 = array($obsMaj_2_1, $obsMaj_2_2, $obsMaj_2_3);
    $obsMin = array($obsMin_1, $obsMin_2, $obsMin_3);
    $obsEtr = array($obsEtr_1, $obsEtr_2, $obsEtr_3);
    $obsSSC = array($obsSSC_1, $obsSSC_2, $obsSSC_3);
    if (modulesExists($mois, $annee, 'palais')) {
        $modules = "ok";
    } else {
        $modules = "nok";
    }
    if ($modules == "ok") {
        $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modules WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
        if ($result_query = $cnx->query($sql)) {
            $compteur = 0;
            $excludePreviousModule = [];
            while ($row = $result_query->fetch()) {
                if ($compteur > 2) {
                    $compteur = 0;
                    $last = array_shift($coord);
                    array_push($coord, $last);
                    $last = array_shift($obsMaj1);
                    array_push($obsMaj1, $last);
                    $last = array_shift($obsMaj2);
                    array_push($obsMaj2, $last);
                    $last = array_shift($obsMin);
                    array_push($obsMin, $last);
                    $last = array_shift($obsEtr);
                    array_push($obsEtr, $last);
                    $last = array_shift($obsSSC);
                    array_push($obsSSC, $last);
                }
                $excludeJour = [];
                $excludeList = getGavExcludeList($row["mod_start"], $row["mod_end"]);
                $excludeList = array_merge($excludeList, $excludePreviousModule);
                array_push($excludeList, $coord[$compteur]);
                addUserPlanning($coord[$compteur], $row["mod_id"], 1, 1);
                if ($obsMaj1[$compteur] != "none") {
                    addUserPlanning($obsMaj1[$compteur], $row["mod_id"], 3, 1);
                }
                if ($obsMaj2[$compteur] != "none") {
                    addUserPlanning($obsMaj2[$compteur], $row["mod_id"], 3, 1);
                }
                if ($obsMin[$compteur] != "none") {
                    addUserPlanning($obsMin[$compteur], $row["mod_id"], 3, 2);
                }
                if ($obsEtr[$compteur] != "none") {
                    addUserPlanning($obsEtr[$compteur], $row["mod_id"], 3, 3);
                }
                if ($obsSSC[$compteur] != "none") {
                    addUserPlanning($obsSSC[$compteur], $row["mod_id"], 3, 4);
                }
                $interMaj = getInterList(2, 1);
                $modType = getModuleType($row["mod_id"], 'palais');
                if ($modType == 2 || $modType == 3) {
                    $nombre = 4;
                } else {
                    $nombre = 5;
                }
                $interMajAssigne = extractInter($interMaj, $excludeList, $nombre, 1);
                foreach ($interMajAssigne as $int) {
                    addUserPlanning($int[0], $row["mod_id"], 2, 1);
                    array_push($excludeList, $int[0]);
                    array_push($excludeJour, $int[0]);
                }
                $interMin = getInterList(2, 2);
                $interMinAssigne = extractInter($interMin, $excludeList, 2, 1);
                foreach ($interMinAssigne as $int) {
                    addUserPlanning($int[0], $row["mod_id"], 2, 2);
                    array_push($excludeList, $int[0]);
                    array_push($excludeJour, $int[0]);
                }
                $interEtr = getInterList(2, 3);
                $interEtrAssigne = extractInter($interEtr, $excludeList, 2, 1);
                foreach ($interEtrAssigne as $int) {
                    addUserPlanning($int[0], $row["mod_id"], 2, 3);
                    array_push($excludeList, $int[0]);
                    array_push($excludeJour, $int[0]);
                }
                $interHO = getInterList(2, 4);
                $interHOAssigne = extractInter($interHO, $excludeList, 2, 0);
                foreach ($interHOAssigne as $int) {
                    addUserPlanning($int[0], $row["mod_id"], 2, 4);
                    array_push($excludeList, $int[0]);
                    array_push($excludeJour, $int[0]);
                }
                $compteur++;
                $excludePreviousModule = $excludeJour;
            }
            addPlanningValide($mois, $annee, 'palais');
            $result_query->closeCursor();
        } else {
            return false;
        }
    }
    updateCompteur("palais");
    return true;
}

function getPlanningPP($mois, $annee) {
    global $cnx;
    $retour = [];
    if (!planningExist($mois, $annee, 'palais')) {
        return false;
    }
    $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modules WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
    if ($result_query = $cnx->query($sql)) {
        $compteur = 0;
        while ($row = $result_query->fetch()) {
            $retour[$compteur]["dates"] = getDates($row["mod_start"], $row["mod_end"]);
            $sql2 = "SELECT p.user_id, user_role, user_perm, user_nom, user_prenom, user_tel3 FROM barreau_planning p LEFT JOIN barreau_users u ON p.user_id=u.user_id WHERE mod_id = " . $row["mod_id"] . " ORDER BY plan_id";
            if ($result_query2 = $cnx->query($sql2)) {
                $retour[$compteur]["interMaj"] = "";
                $retour[$compteur]["obsMaj"] = "";
                $retour[$compteur]["obsMin"] = "";
                $retour[$compteur]["obsEtr"] = "";
                $retour[$compteur]["obsSSC"] = "";
                while ($row2 = $result_query2->fetch()) {
                    if ($row2["user_role"] == 1) {
                        $retour[$compteur]["coord"] = $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a>";
                    }
                    if ($row2["user_role"] == 2 && $row2["user_perm"] == 1) {
                        $retour[$compteur]["interMaj"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 3 && $row2["user_perm"] == 1) {
                        $retour[$compteur]["obsMaj"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 2 && $row2["user_perm"] == 2) {
                        $retour[$compteur]["interMin"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 3 && $row2["user_perm"] == 2) {
                        $retour[$compteur]["obsMin"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 2 && $row2["user_perm"] == 3) {
                        $retour[$compteur]["interEtr"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 3 && $row2["user_perm"] == 3) {
                        $retour[$compteur]["obsEtr"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 2 && $row2["user_perm"] == 4) {
                        $retour[$compteur]["interSSC"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                    if ($row2["user_role"] == 3 && $row2["user_perm"] == 4) {
                        $retour[$compteur]["obsSSC"].= $row2["user_nom"] . " " . $row2["user_prenom"] . "<br>Tel : <a href='tel:" . $row2["user_tel3"] . "' class='telephone'>" . $row2["user_tel3"] . "</a><br>";
                    }
                }
            }
            $compteur++;
        }
        if ($compteur == 0) {
            return false;
        }
    } else {
        return false;
    }
    return $retour;
}

function addPlanningValide($mois, $annee, $perm) {
    global $cnx;
    $sql = "INSERT INTO barreau_planning_valide (val_mois, val_annee, val_perm, val_valide) VALUES (" . $mois . "," . $annee . ",'" . $perm . "',0)";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function deletePlanningValide($mois, $annee, $perm) {
    global $cnx;
    $sql = "DELETE FROM barreau_planning_valide WHERE val_mois = " . $mois . " AND val_annee = " . $annee . " AND val_perm = '" . $perm . "'";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function validePlanning($mois, $annee, $perm) {
    global $cnx;
    $sql = "UPDATE barreau_planning_valide SET val_valide = 1 WHERE val_mois = " . $mois . " AND val_annee = " . $annee . " AND val_perm = '" . $perm . "'";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function isPlanningValide($mois, $annee, $perm) {
    global $cnx;
    $sql = "SELECT val_valide FROM barreau_planning_valide WHERE val_mois = " . $mois . " AND val_annee = " . $annee . " AND val_perm = '" . $perm . "'";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if ($row["val_valide"] == 1) {
            return true;
        } else {
            return false;
        }
    }
}

function isPlanningValideFromDate($date, $perm) {
    global $cnx;
    if ($perm == "gav") {
        $modules = "barreau_modulesGAV";
    } else {
        $modules = "barreau_modules";
    }
    $sql = "SELECT mod_mois, mod_annee FROM " . $modules . " WHERE mod_start <= '" . $date . "' AND mod_end >= '" . $date . "' LIMIT 0,1";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if (isPlanningValide($row["mod_mois"], $row["mod_annee"], $perm)) {
            return true;
        } else {
            return false;
        }
    }
}

function deletePlanning($mois, $annee, $mode) {
    global $cnx;
    $planId = [];
    if ($mode == "gav") {
        $module = "barreau_modulesGAV";
        $table = "barreau_planningGAV";
    } else {
        $module = "barreau_modules";
        $table = "barreau_planning";
    }
    $sql = "SELECT plan_id FROM " . $table . " p LEFT JOIN " . $module . " m ON p.mod_id=m.mod_id WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($planId, $row["plan_id"]);
        }
    }
    foreach ($planId as $id) {
        $sql = "DELETE FROM " . $table . " WHERE plan_id = " . $id;
        $result_query = $cnx->query($sql);
    }
    if ($mode == "gav") {
        $sql = "SELECT MIN(mod_start) as min, MAX(mod_end) as max FROM barreau_modulesGAV WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee;
        if ($result_query = $cnx->query($sql)) {
            $row = $result_query->fetch();
            $sql = "DELETE FROM barreau_planningGAVJour WHERE plan_jour_date >= '" . $row["min"] . "' AND plan_jour_date <= '" . $row["max"] . "'";
            $result_query = $cnx->query($sql);
        }
    }
    deletePlanningValide($mois, $annee, $mode);
    updateCompteur("gav");
    updateCompteur("palais");
    return true;
}

function getModulePP($date) {
    global $cnx;
    $retour = [];
    if (!moduleExist($date, 'palais')) {
        return false;
    }
    $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modules WHERE mod_start <= '" . $date . "' AND mod_end >= '" . $date . "'";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        $sql2 = "SELECT p.user_id, user_role, user_perm, user_nom, user_prenom, user_tel3 FROM barreau_planning p LEFT JOIN barreau_users u ON p.user_id=u.user_id WHERE mod_id = " . $row["mod_id"] . " ORDER BY plan_id";
        if ($result_query2 = $cnx->query($sql2)) {
            $retour["mod_id"] = $row["mod_id"];
            $retour["coord"] = [];
            $retour["interMaj"] = [];
            $retour["obsMaj"] = [];
            $retour["interMin"] = [];
            $retour["obsMin"] = [];
            $retour["interEtr"] = [];
            $retour["obsEtr"] = [];
            $retour["interSSC"] = [];
            $retour["obsSSC"] = [];
            while ($row2 = $result_query2->fetch()) {
                if ($row2["user_role"] == 1) {
                    array_push($retour["coord"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 2 && $row2["user_perm"] == 1) {
                    array_push($retour["interMaj"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 3 && $row2["user_perm"] == 1) {
                    array_push($retour["obsMaj"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 2 && $row2["user_perm"] == 2) {
                    array_push($retour["interMin"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 3 && $row2["user_perm"] == 2) {
                    array_push($retour["obsMin"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 2 && $row2["user_perm"] == 3) {
                    array_push($retour["interEtr"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 3 && $row2["user_perm"] == 3) {
                    array_push($retour["obsEtr"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 2 && $row2["user_perm"] == 4) {
                    array_push($retour["interSSC"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
                if ($row2["user_role"] == 3 && $row2["user_perm"] == 4) {
                    array_push($retour["obsSSC"], array($row2["user_id"], $row2["user_nom"], $row2["user_prenom"], $row2["user_tel3"]));
                }
            }
        }
    }
    return $retour;
}

function getDesignationList($date, $excludeArray) {
    global $cnx;
    $retour = [];
    if (count($excludeArray) > 0) {
        $excludeList = implode(",", $excludeArray);
        $condition = " AND des_avocat NOT IN (" . $excludeList . ")";
    } else {
        $condition = "";
    }
    $sql = "SELECT des_id, des_code, des_affaire, des_heure, des_avocat, user_nom, user_prenom, des_nature, des_prevPrenom, des_prevNom, des_juge, nature_libelle FROM barreau_designations d, barreau_natures n, barreau_users u WHERE d.des_nature=n.nature_code AND u.user_code = des_avocat AND des_date = '" . $date . "'" . $condition;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getDesignation($avocat, $date) {
    global $cnx;
    $retour = [];
    $sql = "SELECT des_id, des_code, des_affaire, des_heure, des_avocat, des_nature, des_prevPrenom, des_prevNom, des_juge, nature_libelle FROM barreau_designations d LEFT JOIN barreau_natures n ON d.des_nature=n.nature_code  WHERE des_date = '" . $date . "' AND des_avocat = " . $avocat;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getJourPP($date) {
    global $cnx;
    $retour = [];
    $retour['coord'] = [];
    $retour['interMaj'] = [];
    $retour['interMin'] = [];
    $retour['interEtr'] = [];
    $retour['interHo'] = [];
    $retour['obsMaj'] = [];
    $retour['obsMin'] = [];
    $retour['obsEtr'] = [];
    $retour['obsHo'] = [];
    $retour['designations'] = [];
    $excludeArray = [];
    $sql1 = "SELECT mod_id, mod_start, mod_end FROM barreau_modules WHERE mod_start <= '" . $date . "' AND mod_end >= '" . $date . "'";
    if ($result_query1 = $cnx->query($sql1)) {
        $row1 = $result_query1->fetch();
        $sql = "SELECT p.user_id, user_role, user_perm, user_nom, user_prenom, user_code,user_tel3 FROM barreau_planning p LEFT JOIN barreau_users u ON p.user_id=u.user_id WHERE mod_id = " . $row1["mod_id"] . " ORDER BY plan_id";
        if ($result_query = $cnx->query($sql)) {
            while ($row = $result_query->fetch()) {
                $user = [];
                $user['infos']['user_code'] = $row["user_code"];
                array_push($excludeArray, $row["user_code"]);
                $user['infos']['user_prenom'] = $row["user_prenom"];
                $user['infos']['user_nom'] = $row["user_nom"];
                $user['infos']['user_role'] = $row["user_role"];
                $user['infos']['user_perm'] = $row["user_perm"];
                $user['des'] = getDesignation($row["user_code"], $date);
                if ($row["user_role"] == 1) {
                    array_push($retour['coord'], $user);
                }
                if ($row["user_role"] == 2) {
                    if ($row["user_perm"] == 1) {
                        array_push($retour['interMaj'], $user);
                    }
                    if ($row["user_perm"] == 2) {
                        array_push($retour['interMin'], $user);
                    }
                    if ($row["user_perm"] == 3) {
                        array_push($retour['interEtr'], $user);
                    }
                    if ($row["user_perm"] == 4) {
                        array_push($retour['interHo'], $user);
                    }
                }
                if ($row["user_role"] == 3) {
                    if ($row["user_perm"] == 1) {
                        array_push($retour['obsMaj'], $user);
                    }
                    if ($row["user_perm"] == 2) {
                        array_push($retour['obsMin'], $user);
                    }
                    if ($row["user_perm"] == 3) {
                        array_push($retour['obsEtr'], $user);
                    }
                    if ($row["user_perm"] == 4) {
                        array_push($retour['obsHo'], $user);
                    }
                }
            }
        }
        $retour['designations'] = getDesignationList($date, $excludeArray);
        $retour['notes'] = getNotes($date);
    }
    return $retour;
}

function addCoordPlanningGAV($userId, $modId) {
    global $cnx;
    $sql = "INSERT INTO barreau_planningGAV (mod_id,user_id) VALUES (" . $modId . "," . $userId . ")";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        return true;
    }
}

function addUserPlanningGAV($date, $userId) {
    global $cnx;
    $sql = "INSERT INTO barreau_planningGAVJour (plan_jour_date, user_id) VALUES ('" . $date . "'," . $userId . ")";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    } else {
        setCompteur($userId, 1);
        return true;
    }
}

function deleteUserPlanningGAV($user_id, $mod_id, $date, $mode) {
    global $cnx;
    if ($mode == "coord") {
        $sql = "DELETE FROM barreau_planningGAV WHERE user_id = " . $user_id . " AND mod_id = " . $mod_id;
        if (!$result_query = $cnx->query($sql)) {
            return false;
        } else {
            return true;
        }
    } else {
        $sql = "DELETE FROM barreau_planningGAVJour WHERE user_id = " . $user_id . " AND plan_jour_date = '" . $date . "'";
        if (!$result_query = $cnx->query($sql)) {
            return false;
        } else {
            return true;
        }
    }
}

function getDatesModule($start, $end) {
    $retour = [];
    setlocale(LC_TIME, "fr_FR.UTF-8", "French_France.1252");
    $start = new DateTime($start);
    $interval = new DateInterval('P1D');
    $end = new DateTime($end);
    $end = $end->modify('+1 day');
    $period = new DatePeriod($start, $interval, $end);
    foreach ($period as $key => $value) {
        $subRetour = [];
        $subRetour[0] = $value->format('Y-m-d');
        $subRetour[1] = $value->format('w');
        array_push($retour, $subRetour);
    }
    return $retour;
}

function getChevGAVStatus($userCode) {
    global $cnx;
    $sql = "SELECT user_chevro FROM barreau_snapshot WHERE user_code = " . $userCode . " AND user_role = 2 AND user_perm = 5";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row["user_chevro"];
    } else {
        return false;
    }
}

function extractArrayJour($array, $size, $exclude, $index) {
    $retour = [];
    $compteur = 0;
    $arraySize = count($array);
    echo ("extractArrayJour(" . $array . "," . $size . "," . $exclude . "," . $index . ")<br>");
    if ($index == 0) {
        $run = true;
    } else {
        $run = false;
    }
    $i = 0;
    while ($compteur < $size && $i < 2 * $arraySize) {
        if ($run && $array[$i % $arraySize]["user_id"] != $exclude) {
            array_push($retour, $array[$i % $arraySize]);
            $compteur++;
        }
        if ($array[$i % $arraySize]["user_id"] == $index) {
            echo ("Index " . $index . " trouv<br>");
            $run = true;
        }
        $i++;
    }
    return $retour;
}

function initCompteurJour() {
    global $cnx;
    $retour = [];
    $sql = "SELECT user_id, 0 as compt FROM barreau_dispos ORDER BY dispo_id";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            $retour[$row["user_id"]] = 0;
        }
    }
    return $retour;
}

function genPlanningGAV($mois, $annee, $coord_1, $coord_2, $coord_3) {
    global $cnx;
    $retour = [];
    $coord = array($coord_1, $coord_2, $coord_3);
    if (modulesExists($mois, $annee, 'gav')) {
        $modules = "ok";
    } else {
        $modules = "nok";
    }
    if ($modules == "ok") {
        $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modulesGAV WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
        if ($result_query = $cnx->query($sql)) {
            $joursEcart = 6;
            $interGav = getDispos();
            $lun = getDispoJour(1);
            $mar = getDispoJour(2);
            $mer = getDispoJour(3);
            $jeu = getDispoJour(4);
            $ven = getDispoJour(5);
            $sam = getDispoJour(6);
            $dim = getDispoJour(0);
            $rows = $result_query->fetchAll();
            $assignations = [];
            foreach ($rows as $row) {
                $dates = getDatesModule($row["mod_start"], $row["mod_end"]);
                foreach ($dates as $date) {
                    if ($date[1] == 1 || $date[1] == 2 || $date[1] == 3) {
                        $compteur = 7;
                    } else {
                        $compteur = 5;
                    }
                    for ($i = 0;$i < $compteur;$i++) {
                        $assignation = [];
                        $assignation["date"] = $date[0];
                        $assignation["jour"] = $date[1];
                        $assignation["numero"] = $i + 1;
                        $nbUsersDispos = count(getDispoJour($date[1], 0));
                        $assignation["valeur"] = floor(10000 * ($compteur / $nbUsersDispos));
                        array_push($assignations, $assignation);
                    }
                }
            }
            array_multisort(array_column($assignations, "valeur"), SORT_DESC, $assignations);
            $empty = 1;
            $tour = 0;
            while ($empty > 0) {
                $tour++;
                $compteur = 0;
                $compteurJour = initCompteurJour();
                foreach ($rows as $row) {
                    if ($compteur > 2) {
                        $compteur = 0;
                        $last = array_shift($coord);
                        array_push($coord, $last);
                    }
                    addCoordPlanningGAV($coord[$compteur], $row["mod_id"]);
                    $compteur++;
                }
                $empty = 0;
                foreach ($assignations as $assignation) {
                    $usersJour = getDispoJour($assignation["jour"]);
                    $usersAssignables = [];
                    foreach ($usersJour as $userJour) {
                        $assignable = 1;
                        if (getCoord($assignation["date"]) == $userJour["user_id"]) {
                            $assignable = 0;
                        }
                        if (isAssigned($userJour["user_id"], $assignation["date"], $joursEcart)) {
                            $assignable = 0;
                        }
                        if ($assignable == 1) {
                            array_push($usersAssignables, $userJour);
                        }
                    }
                    if (count($usersAssignables) == 0) {
                        $empty++;
                    }
                    $min = min(array_column($usersAssignables, 'compteur'));
                    $max = max(array_column($usersAssignables, 'compteur'));
                    if ($min <> $max) {
                        $assignableMini = [];
                        foreach ($usersAssignables as $shortList) {
                            if ($shortList["compteur"] == $min) {
                                array_push($assignableMini, $shortList);
                            }
                        }
                        for ($i = 1;$i < 8;$i++) {
                            $shortList = [];
                            foreach ($assignableMini as $userAssignable) {
                                if ($userAssignable["dispo"] == $i) {
                                    array_push($shortList, $userAssignable);
                                }
                            }
                            if (count($shortList) > 1) {
                                $rand_key = array_rand($shortList, 1);
                                addUserPlanningGAV($assignation["date"], $shortList[$rand_key]["user_id"]);
                                $compteurJour[$shortList[$rand_key]["user_id"]]++;
                                break;
                            } elseif (count($shortList) == 1) {
                                addUserPlanningGAV($assignation["date"], $shortList[0]["user_id"]);
                                $compteurJour[$shortList[0]["user_id"]]++;
                                break;
                            }
                        }
                    } else {
                        for ($i = 1;$i < 8;$i++) {
                            $shortList = [];
                            foreach ($usersAssignables as $userAssignable) {
                                if ($userAssignable["dispo"] == $i) {
                                    array_push($shortList, $userAssignable);
                                }
                            }
                            if (count($shortList) > 1) {
                                $rand_key = array_rand($shortList, 1);
                                addUserPlanningGAV($assignation["date"], $shortList[$rand_key]["user_id"]);
                                $compteurJour[$shortList[$rand_key]["user_id"]]++;
                                break;
                            } elseif (count($shortList) == 1) {
                                addUserPlanningGAV($assignation["date"], $shortList[0]["user_id"]);
                                $compteurJour[$shortList[0]["user_id"]]++;
                                break;
                            }
                        }
                    }
                }
                if ($empty <> 0) {
                    deletePlanning($mois, $annee, 'gav');
                }
                if ($tour > 4) {
                    break;
                }
            }
            addPlanningValide($mois, $annee, 'gav');
            updateCompteur("gav");
            $result_query->closeCursor();
        } else {
            return false;
        }
    }
    return true;
}

function getAssignDate($user, $mois, $annee) {
    global $cnx;
    $retour = [];
    $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modulesGAV WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
    if ($result_query = $cnx->query($sql)) {
        $rows = $result_query->fetchAll();
        $compteur = 0;
        foreach ($rows as $row) {
            if ($compteur == 0) {
                $start = $row["mod_start"];
                $compteur++;
            }
            $end = $row["mod_end"];
        }
    }
    $sql = "SELECT plan_jour_date as date, user_id as user FROM barreau_planningGAVJour WHERE user_id= " . $user . " AND plan_jour_date >= '" . $start . "' AND plan_jour_date <= '" . $end . "'";
    if ($result_query = $cnx->query($sql)) {
        $rows = $result_query->fetchAll();
        foreach ($rows as $row) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function switchUsers($date, $userOld, $userNew) {
    global $cnx;
    $sql = "UPDATE barreau_planningGAVJour SET user_id = " . $userNew . " WHERE user_id = " . $userOld . " AND plan_jour_date = '" . $date . "'";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    }
    return true;
}
function setCompteur($userId, $valeur) {
    global $cnx;
    $sql = "SELECT compteur FROM barreau_dispos WHERE user_id = " . $userId;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        $compteur = $row["compteur"];
        $compteur+= $valeur;
        $sql2 = "UPDATE barreau_dispos SET compteur = " . $compteur . " WHERE user_id = " . $userId;
        if (!$result_query = $cnx->query($sql2)) {
            return false;
        }
    }
    return true;
}

function resetCompteur() {
    global $cnx;
    $sql = "UPDATE barreau_dispos SET compteur = 0";
    if (!$result_query = $cnx->query($sql)) {
        return false;
    }
    return true;
}
function updateCompteurGAV() {
    global $cnx;
    $sql = "SELECT date FROM barreau_compteurDate WHERE date_id = 1";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        $date = $row["date"];
        $sql2 = "SELECT user_id FROM barreau_dispos";
        if ($result_query2 = $cnx->query($sql2)) {
            $rows = $result_query2->fetchAll();
            foreach ($rows as $row) {
                $sql3 = "SELECT COUNT(user_id) as nombre FROM barreau_planningGAVJour WHERE user_id = " . $row["user_id"] . " AND plan_jour_date >= '" . $date . "'";
                if ($result_query3 = $cnx->query($sql3)) {
                    $compteur = $result_query3->fetch();
                    $compte = $compteur["nombre"];
                    $sql4 = "UPDATE barreau_dispos SET compteur = " . $compte . " WHERE user_id = " . $row["user_id"];
                    $result_query4 = $cnx->query($sql4);
                }
            }
        }
    }
}
function resetCompteurPalais() {
    global $cnx;
    $sql = "UPDATE barreau_users SET user_compt_1 = 0, user_compt_2 = 0, user_compt_3 = 0, user_compt_4 = 0, user_compt_tot = 0";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function updateCompteurPalais() {
    global $cnx;
    resetCompteurPalais();
    $sql = "SELECT date FROM barreau_compteurDate WHERE date_id = 2";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        $date = $row["date"];
        $sql2 = "SELECT DISTINCT(p.user_id) FROM barreau_planning p LEFT JOIN barreau_users u ON p.user_id = u.user_id WHERE p.user_role = 2 ORDER BY user_nom";
        if ($result_query2 = $cnx->query($sql2)) {
            $rows = $result_query2->fetchAll();
            foreach ($rows as $row) {
                $modIdArray = [];
                $sql3 = "SELECT mod_id FROM barreau_modules WHERE mod_end >= '" . $date . "'";
                if ($result_query3 = $cnx->query($sql3)) {
                    while ($row3 = $result_query3->fetch()) {
                        array_push($modIdArray, $row3["mod_id"]);
                    }
                }
                $modIdArray = implode(",", $modIdArray);
                for ($i = 1;$i < 5;$i++) {
                    $sql3 = "SELECT COUNT(user_id) as nombre FROM barreau_planning WHERE user_id = " . $row["user_id"] . " AND user_perm = " . $i . " AND user_role = 2 AND mod_id IN (" . $modIdArray . ")";
                    if ($result_query3 = $cnx->query($sql3)) {
                        $compteur = $result_query3->fetch();
                        $compte = $compteur["nombre"];
                        $sql4 = "UPDATE barreau_users SET user_compt_" . $i . " = " . $compte . " WHERE user_id = " . $row["user_id"];
                        $result_query4 = $cnx->query($sql4);
                    }
                }
                $sql = "UPDATE barreau_users SET user_compt_tot = user_compt_1+user_compt_2+user_compt_3+user_compt_4 WHERE user_id = " . $row["user_id"];
                $result_query = $cnx->query($sql);
            }
        }
    }
}

function updateCompteur($mode) {
    if ($mode == "gav") {
        updateCompteurGAV();
    } else {
        updateCompteurPalais();
    }
}

function getAssigned($mois, $annee, $nb) {
    global $cnx;
    $retour = [];
    $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modulesGAV WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
    if ($result_query = $cnx->query($sql)) {
        $rows = $result_query->fetchAll();
        $compteur = 0;
        foreach ($rows as $row) {
            if ($compteur == 0) {
                $start = $row["mod_start"];
                $compteur++;
            }
            $end = $row["mod_end"];
        }
    }
    $sql = "SELECT COUNT(user_id) as nb, user_id FROM barreau_planningGAVJour WHERE plan_jour_date >= '" . $start . "' AND plan_jour_date <= '" . $end . "' GROUP BY user_id";
    $assigne = [];
    if ($result_query = $cnx->query($sql)) {
        $rows = $result_query->fetchAll();
        foreach ($rows as $row) {
            array_push($assigne, $row["user_id"]);
            if ($row["nb"] == $nb) {
                array_push($retour, $row["user_id"]);
            }
        }
    }
    if ($nb == 0) {
        $dispos = [];
        $sql = "SELECT user_id FROM barreau_dispos";
        if ($result_query = $cnx->query($sql)) {
            $rows = $result_query->fetchAll();
            foreach ($rows as $row) {
                array_push($dispos, $row["user_id"]);
            }
        }
        $retour = array_diff($dispos, $assigne);
    }
    return $retour;
}

function isAssigned($userId, $date, $duree) {
    global $cnx;
    $retour = [];
    $days_ago = date('Y-m-d', strtotime('-' . $duree . ' days', strtotime($date)));
    $days_next = date('Y-m-d', strtotime('+' . $duree . ' days', strtotime($date)));
    $sql = "SELECT COUNT(user_id) as yes FROM barreau_planningGAVJour WHERE plan_jour_date >= '" . $days_ago . "' AND plan_jour_date <= '" . $days_next . "' AND user_id = " . $userId;
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        if ($row["yes"] > 0) {
            return true;
        } else {
            return false;
        }
    }
}

function getCoord($date) {
    global $cnx;
    $sql = "SELECT user_id FROM barreau_planningGAV p LEFT JOIN barreau_modulesGAV m ON p.mod_id = m.mod_id WHERE mod_start <= '" . $date . "' AND mod_end >= '" . $date . "'";
    if ($result_query = $cnx->query($sql)) {
        $row = $result_query->fetch();
        return $row["user_id"];
    }
}

function getInterAnnexe($userCode) {
    global $cnx;
    $retour = "";
    $sql = "SELECT distinct(user_perm) as res FROM barreau_snapshot WHERE user_perm <> 5 AND user_role = 2 AND user_code = " . $userCode;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            if ($row["res"] == 1) {
                $retour.= "MAJ";
            } else if ($row["res"] == 2) {
                $retour.= "MIN";
            } else if ($row["res"] == 3) {
                $retour.= "ETR";
            } else if ($row["res"] == 4) {
                $retour.= "SSC";
            }
            $retour.= ", ";
        }
    }
    $retour = substr($retour, 0, -2);
    return $retour;
}

function getPlanningGAV($mois, $annee) {
    global $cnx;
    $retour = [];
    if (!planningExist($mois, $annee, 'gav')) {
        return false;
    }
    $sql = "SELECT mod_id, mod_start, mod_end FROM barreau_modulesGAV WHERE mod_mois = " . $mois . " AND mod_annee = " . $annee . " ORDER BY mod_start";
    if ($result_query = $cnx->query($sql)) {
        $compteur = 0;
        while ($row = $result_query->fetch()) {
            $sql2 = "SELECT p.user_id, user_nom, user_prenom, user_tel3 FROM barreau_planningGAV p LEFT JOIN barreau_users u ON p.user_id=u.user_id WHERE mod_id = " . $row["mod_id"];
            $coord = [];
            if ($result_query2 = $cnx->query($sql2)) {
                while ($row2 = $result_query2->fetch()) {
                    array_push($coord, $row2);
                }
            }
            $dates = getDatesModule($row["mod_start"], $row["mod_end"]);
            foreach ($dates as $date) {
                $subRetour[0] = dateToFrench($date[0], 'l j F Y');
                $subRetour[1] = $coord;
                $sql3 = "SELECT j.user_id, user_code, user_nom, user_prenom, user_tel3 FROM barreau_planningGAVJour j LEFT JOIN barreau_users u ON j.user_id=u.user_id WHERE plan_jour_date = '" . $date[0] . "' ORDER BY plan_jour_id";
                if ($result_query3 = $cnx->query($sql3)) {
                    $inter = [];
                    while ($row3 = $result_query3->fetch()) {
                        if ($interv = getInterAnnexe($row3["user_code"])) {
                            $row3["user_inter"] = "<i>" . $interv . "</i><br>";
                        } else {
                            $row3["user_inter"] = "";
                        }
                        array_push($inter, $row3);
                    }
                    $subRetour[2] = $inter;
                }
                array_push($retour, $subRetour);
            }
        }
    }
    return $retour;
}

function getUserGAVList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT DISTINCT(user_id), user_login, user_prenom, user_nom, user_email, u.user_code, user_tel1, user_tel2, user_tel3, user_tel4, user_email_perso FROM barreau_users u, barreau_snapshot s WHERE s.user_code=u.user_code AND user_perm = 5 ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
        return $retour;
    } else {
        return $sql;
    }
}

function getJourGAV($date) {
    global $cnx;
    $retour = [];
    $retour["date"] = dateToFrench($date, 'l j F Y');;
    $sql = "SELECT p.user_id, user_prenom, user_nom, m.mod_id FROM barreau_users u, barreau_modulesGAV m, barreau_planningGAV p WHERE p.user_id = u.user_id AND m.mod_id=p.mod_id AND m.mod_start <= '" . $date . "' AND m.mod_end >= '" . $date . "'";
    $retour["coord"] = [];
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour["coord"], $row);
        }
    }
    $retour["inter"] = [];
    $sql = "SELECT p.user_id, user_prenom, user_nom FROM barreau_users u, barreau_planningGAVJour p WHERE p.user_id = u.user_id AND plan_jour_date = '" . $date . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour["inter"], $row);
        }
    }
    return $retour;
}

function getDispoJourLong($jour, $chevro) {
    global $cnx;
    $retour = [];
    switch ($jour) {
        case 0:
            $condition = "AND dispo_dim = 1";
        break;
        case 1:
            $condition = "AND dispo_lun = 1";
        break;
        case 2:
            $condition = "AND dispo_mar = 1";
        break;
        case 3:
            $condition = "AND dispo_mer = 1";
        break;
        case 4:
            $condition = "AND dispo_jeu = 1";
        break;
        case 5:
            $condition = "AND dispo_ven = 1";
        break;
        case 6:
            $condition = "AND dispo_sam = 1";
        break;
    }
    $sql = "SELECT dispo_id, d.user_code, d.user_id, u.user_prenom, u.user_nom, dispo_lun+dispo_mar+dispo_mer+dispo_jeu+dispo_ven+dispo_sam+dispo_dim as dispo FROM barreau_dispos d LEFT JOIN barreau_snapshot s ON d.user_code=s.user_code LEFT JOIN barreau_users u ON u.user_id=d.user_id WHERE user_perm = 5 AND user_role = 2 " . $condition . " ORDER BY dispo";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getDispoJourOld($jour, $chevro) {
    global $cnx;
    $retour = [];
    switch ($jour) {
        case 0:
            $condition = "AND dispo_dim = 1";
        break;
        case 1:
            $condition = "AND dispo_lun = 1";
        break;
        case 2:
            $condition = "AND dispo_mar = 1";
        break;
        case 3:
            $condition = "AND dispo_mer = 1";
        break;
        case 4:
            $condition = "AND dispo_jeu = 1";
        break;
        case 5:
            $condition = "AND dispo_ven = 1";
        break;
        case 6:
            $condition = "AND dispo_sam = 1";
        break;
    }
    $sql = "SELECT d.user_id FROM barreau_dispos d LEFT JOIN barreau_snapshot s ON d.user_code=s.user_code LEFT JOIN barreau_users u ON u.user_id=d.user_id WHERE user_perm = 5 AND user_role = 2 " . $condition;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getDispoJour($jour) {
    global $cnx;
    $retour = [];
    switch ($jour) {
        case 0:
            $condition = "WHERE dispo_dim = 1";
        break;
        case 1:
            $condition = "WHERE dispo_lun = 1";
        break;
        case 2:
            $condition = "WHERE dispo_mar = 1";
        break;
        case 3:
            $condition = "WHERE dispo_mer = 1";
        break;
        case 4:
            $condition = "WHERE dispo_jeu = 1";
        break;
        case 5:
            $condition = "WHERE dispo_ven = 1";
        break;
        case 6:
            $condition = "WHERE dispo_sam = 1";
        break;
    }
    $sql = "SELECT dispo_id, user_code, user_id, dispo_lun+dispo_mar+dispo_mer+dispo_jeu+dispo_ven+dispo_sam+dispo_dim as dispo, compteur FROM barreau_dispos " . $condition . " ORDER BY dispo";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getDispos() {
    global $cnx;
    $retour = [];
    $sql = "SELECT dispo_id, user_code, user_id, dispo_lun, dispo_mar, dispo_mer, dispo_jeu, dispo_ven, dispo_sam, dispo_dim, dispo_lun+dispo_mar+dispo_mer+dispo_jeu+dispo_ven+dispo_sam+dispo_dim as dispo, 0 as user_desi FROM barreau_dispos ORDER BY dispo";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function updateScore($userId, $score) {
    global $cnx;
    $sql = "UPDATE barreau_dispos SET dispo_score = " . $score . " WHERE user_id = " . $userId;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    }
    return true;
}

function getDispoList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT dispo_id, d.user_code, d.user_id, user_prenom, user_nom, dispo_lun, dispo_mar, dispo_mer, dispo_jeu, dispo_ven, dispo_sam, dispo_dim, compteur FROM barreau_dispos d LEFT JOIN barreau_users u ON d.user_code=u.user_code ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getCompteurList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT DISTINCT(p.user_id), user_prenom, user_nom, user_tel1, user_tel2, user_compt_1, user_compt_2, user_compt_3, user_compt_4, user_compt_tot FROM barreau_planning p LEFT JOIN barreau_users u ON p.user_id = u.user_id WHERE p.user_role = 2 ORDER BY user_nom";
    if ($result_query = $cnx->query($sql)) {
        $compt = 0;
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
            $compt++;
        }
        if ($compt == 0) {
            $sql2 = "SELECT user_id, user_prenom, user_nom, user_tel1, user_tel2, user_compt_1, user_compt_2, user_compt_3, user_compt_4, user_compt_tot FROM barreau_users ORDER BY user_nom";
            if ($result_query2 = $cnx->query($sql2)) {
                while ($row2 = $result_query2->fetch()) {
                    array_push($retour, $row2);
                    $compt++;
                }
                return $retour;
            } else {
                return false;
            }
        }
        return $retour;
    }
}

function updateDateCompteur($date, $mode) {
    global $cnx;
    if ($mode == 'gav') {
        $dateId = 1;
    } else {
        $dateId = 2;
    }
    $sql = "UPDATE barreau_compteurDate SET date = '" . $date . "' WHERE date_id = " . $dateId;
    if (!$result_query = $cnx->query($sql)) {
        return false;
    }
    return true;
}

function getDateCompteur($mode) {
    global $cnx;
    $retour = [];
    if ($mode == 'gav') {
        $dateId = 1;
    } else {
        $dateId = 2;
    }
    $sql = "SELECT date FROM barreau_compteurDate WHERE date_id = " . $dateId;
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function updateDispos($infos) {
    global $cnx;
    foreach ($infos as $info) {
        $sql = "UPDATE barreau_dispos SET ";
        $sql.= "dispo_lun=" . $info[1] . ", ";
        $sql.= "dispo_mar=" . $info[2] . ", ";
        $sql.= "dispo_mer=" . $info[3] . ", ";
        $sql.= "dispo_jeu=" . $info[4] . ", ";
        $sql.= "dispo_ven=" . $info[5] . ", ";
        $sql.= "dispo_sam=" . $info[6] . ", ";
        $sql.= "dispo_dim=" . $info[7];
        $sql.= " WHERE user_id =" . $info[0];
        if (!$result_query = $cnx->query($sql)) {
            return false;
        }
    }
    return true;
}

function date_compare($a, $b) {
    $t1 = strtotime($a[0]);
    $t2 = strtotime($b[0]);
    return $t1 - $t2;
}

function getPlanningUser($userId, $admin) {
    global $cnx;
    $retour = [];
    if ($admin == "true") {
        $admin = true;
    } else {
        $admin = false;
    }
    $dateJour = date("Y-m-d");
    $sql = "SELECT p.mod_id, mod_start, mod_end FROM barreau_planningGAV p LEFT JOIN barreau_modulesGAV m ON p.mod_id=m.mod_id WHERE user_id = " . $userId . " AND mod_end >= '" . $dateJour . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            $result = [];
            $dates = getDatesModule($row["mod_start"], $row["mod_end"]);
            foreach ($dates as $date) {
                $result[0] = $date[0];
                $result[1] = dateToFrench($date[0], 'd-m-Y');
                $result[2] = "GAV";
                $result[3] = "Coordinateur";
                $result[4] = 1;
                if ($admin || isPlanningValideFromDate($result[0], "gav")) {
                    array_push($retour, $result);
                }
            }
        }
    }
    $sql = "SELECT plan_jour_date FROM barreau_planningGAVJour WHERE user_id = " . $userId . " AND plan_jour_date >= '" . $dateJour . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            $result = [];
            $result[0] = $row["plan_jour_date"];
            $result[1] = dateToFrench($row["plan_jour_date"], 'd-m-Y');
            $result[2] = "GAV";
            $result[3] = "Intervenant";
            $result[4] = 1;
            if ($admin || isPlanningValideFromDate($result[0], "gav")) {
                array_push($retour, $result);
            }
        }
    }
    $sql = "SELECT plan_id, p.mod_id, user_id, user_role, user_perm, mod_start, mod_end FROM barreau_planning p LEFT JOIN barreau_modules m ON p.mod_id = m.mod_id WHERE user_id = " . $userId . " AND mod_end >= '" . $dateJour . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            $result = [];
            $dates = getDatesModule($row["mod_start"], $row["mod_end"]);
            $compteur = 0;
            foreach ($dates as $date) {
                $result[0] = $date[0];
                $result[1] = dateToFrench($date[0], 'd-m-Y');
                switch ($row["user_perm"]) {
                    case 1:
                        $result[2] = "Majeurs";
                    break;
                    case 2:
                        $result[2] = "Mineurs";
                    break;
                    case 3:
                        $result[2] = "Etrangers";
                    break;
                    case 4:
                        $result[2] = "SSC";
                    break;
                }
                switch ($row["user_role"]) {
                    case 1:
                        $result[3] = "Coordinateur";
                    break;
                    case 2:
                        $result[3] = "Intervenant";
                    break;
                    case 3:
                        $result[3] = "Observateur";
                    break;
                }
                if ($compteur == 0) {
                    $result[4] = 1;
                } else {
                    $result[4] = 0;
                }
                if ($admin || isPlanningValideFromDate($result[0], "gav")) {
                    array_push($retour, $result);
                    $compteur++;
                }
            }
        }
    }
    usort($retour, 'date_compare');
    return $retour;
}

function addRenfort($titre, $lien, $perm) {
    global $cnx;
    $retour = [];
    $sql = "INSERT INTO barreau_renforts (renf_titre,renf_lien,renf_perm) values ('" . $titre . "','" . $lien . "','" . $perm . "')";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function supprRenfort($renfId) {
    global $cnx;
    $retour = [];
    $sql = "DELETE FROM barreau_renforts WHERE renf_id=" . $renfId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function getRenfortsList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT renf_id, renf_titre, renf_lien, renf_perm FROM barreau_renforts ORDER BY renf_perm";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function addNote($date, $note) {
    global $cnx;
    $retour = [];
    $sql = "INSERT INTO barreau_notes (note_text, note_date) values ('" . addslashes(nl2br($note)) . "','" . $date . "')";
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function deleteNote($noteId) {
    global $cnx;
    $retour = [];
    $sql = "DELETE FROM barreau_notes WHERE note_id=" . $noteId;
    if ($result_query = $cnx->query($sql)) {
        return true;
    } else {
        return false;
    }
}

function getNotes($date) {
    global $cnx;
    $retour = [];
    $sql = "SELECT note_id, note_text, note_date FROM barreau_notes WHERE note_date = '" . $date . "'";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function getNoteList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT note_id, note_text, note_date FROM barreau_notes ORDER BY note_date DESC";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            array_push($retour, $row);
        }
    }
    return $retour;
}

function checkUserAssignation($userId, $perm, $date) {
    global $cnx;
    if ($perm == 5) {
        $sql = "SELECT COUNT(user_id) as nb FROM barreau_planningGAVJour WHERE user_id = " . $userId . " AND plan_jour_date = '" . $date . "'";
        if ($result_query = $cnx->query($sql)) {
            $row = $result_query->fetch();
            if ($row["nb"] > 0) {
                return true;
            } else {
                return false;
            }
        }
    } else {
        $mod = getModuleByDate($date, 'palais');
        $sql = "SELECT COUNT(user_id) as nb FROM barreau_planning WHERE user_id = " . $userId . " AND user_perm = " . $perm . " AND mod_id = '" . $mod["mod_id"] . "'";
        if ($result_query = $cnx->query($sql)) {
            $row = $result_query->fetch();
            if ($row["nb"] > 0) {
                return true;
            } else {
                return false;
            }
        }
    }
}

function submitPermutation($perm_type, $avo_1, $avo_1_date, $avo_1_perm, $avo_2, $avo_2_date, $avo_2_perm) {
    global $cnx;
    $sql = "INSERT INTO barreau_permutations (perm_type, avo_1, avo_1_date, avo_1_perm, avo_2, avo_2_date, avo_2_perm) VALUES (" . $perm_type . ", " . $avo_1 . ", '" . $avo_1_date . "', " . $avo_1_perm . ", " . $avo_2 . ", '" . $avo_2_date . "', " . $avo_2_perm . ")";
    if ($result_query = $cnx->query($sql)) {
        sendPermutRequestMail();
        return true;
    } else {
        return false;
    }
}

function getPermutationsList() {
    global $cnx;
    $retour = [];
    $sql = "SELECT perm_id, perm_type, avo_1, avo_1_date, avo_1_perm, avo_2,avo_2_date, avo_2_perm FROM barreau_permutations";
    if ($result_query = $cnx->query($sql)) {
        while ($row = $result_query->fetch()) {
            $resultat = [];
            $sql2 = "SELECT user_nom, user_prenom FROM barreau_users WHERE user_id = " . $row['avo_1'];
            $result_query2 = $cnx->query($sql2);
            $row2 = $result_query2->fetch();
            $sql3 = "SELECT user_nom, user_prenom FROM barreau_users WHERE user_id = " . $row['avo_2'];
            $result_query3 = $cnx->query($sql3);
            $row3 = $result_query3->fetch();
            $resultat["perm_id"] = $row["perm_id"];
            $resultat["avocat1"] = $row2["user_nom"] . " " . $row2["user_prenom"];
            $date = date_create($row["avo_1_date"]);
            $date = date_format($date, 'd-m-Y');
            $resultat["avocat1Date"] = $date;
            $resultat["avocat1Perm"] = $row["avo_1_perm"];
            $resultat["avocat2"] = $row3["user_nom"] . " " . $row3["user_prenom"];
            $date = date_create($row["avo_2_date"]);
            $date = date_format($date, 'd-m-Y');
            $resultat["avocat2Date"] = $date;
            $resultat["avocat2Perm"] = $row["avo_2_perm"];
            array_push($retour, $resultat);
        }
        return $retour;
    } else {
        return false;
    }
}

function processPermutation($permId, $valide) {
    global $cnx;
    if ($valide == 1) {
        $sql = "SELECT perm_type, avo_1, avo_1_date, avo_1_perm, avo_2,avo_2_date, avo_2_perm FROM barreau_permutations WHERE perm_id = " . $permId;
        if ($result_query = $cnx->query($sql)) {
            $row = $result_query->fetch();
            if ($row["perm_type"] == 5) {
                deleteUserPlanningGAV($row["avo_1"], 0, $row["avo_1_date"], 'inter');
                addUserPlanningGAV($row["avo_2_date"], $row["avo_1"]);
                sendPermutConfirmMail($row["avo_1"], $row["avo_2_date"], 5, $row["avo_2"], $row["avo_1_date"]);
                deleteUserPlanningGAV($row["avo_2"], 0, $row["avo_2_date"], 'inter');
                addUserPlanningGAV($row["avo_1_date"], $row["avo_2"]);
                sendPermutConfirmMail($row["avo_2"], $row["avo_1_date"], 5, $row["avo_1"], $row["avo_2_date"]);
            } else {
                $mod1 = getModuleByDate($row["avo_1_date"], 'palais');
                $mod2 = getModuleByDate($row["avo_2_date"], 'palais');
                deleteUserPlanning($row["avo_1"], $mod1["mod_id"]);
                addUserPlanning($row["avo_1"], $mod2["mod_id"], 2, $row["avo_2_perm"]);
                sendPermutConfirmMail($row["avo_1"], $row["avo_2_date"], $row["avo_2_perm"], $row["avo_2"], $row["avo_1_date"]);
                deleteUserPlanning($row["avo_2"], $mod2["mod_id"]);
                addUserPlanning($row["avo_2"], $mod1["mod_id"], 2, $row["avo_1_perm"]);
                sendPermutConfirmMail($row["avo_2"], $row["avo_1_date"], $row["avo_1_perm"], $row["avo_1"], $row["avo_2_date"]);
            }
            updateCompteur("gav");
            updateCompteur("palais");
            $sql = "DELETE FROM barreau_permutations WHERE perm_id = " . $permId;
            if ($result_query = $cnx->query($sql)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    } else {
        $sql = "DELETE FROM barreau_permutations WHERE perm_id = " . $permId;
        if ($result_query = $cnx->query($sql)) {
            return true;
        } else {
            return false;
        }
    }
}

function sendInfoMail($dest, $log, $pwd) {
    global $urlSite;
    global $emailSite;
    $contenu = "Voici les informations qui permettront de vous connecter :<br/><br/>";
    $contenu.= "<b>Adresse du site</b> : <a href='" . $urlSite . "'>" . $urlSite . "</a><br/>";
    $contenu.= "<b>Login</b> : " . $log . "<br/>";
    $contenu.= "<b>Mot de passe : </b> : " . $pwd . "<br/><br/>";
    $contenu.= "La Permanence Pnale.";
    $message.= nl2br($contenu);
    $headers = "Content-Type: text/html; charset=utf-8
";
    $headers.= "From: " . $emailSite . "
";
    $headers.= "Bcc: arnaud.voland@free.fr
";
    $headers.= "Reply-To: " . $emailSite;
    if (mail($dest, 'IMPORTANT : Vos identifiants de connexion au site de la permanence du Palais de Montpellier', $message, $headers)) {
        return true;
    } else {
        return false;
    }
}

function sendPermutRequestMail() {
    global $urlSite;
    global $emailSite;
    $contenu = "Bonjour, <br/><br/>";
    $contenu.= "le bon gnie de la lampe vous informe qu'il y a une nouvelle demande de permutation en attente de validation.<br/><br/>";
    $contenu.= "Passez une excellente journe.";
    $message.= nl2br($contenu);
    $headers = "Content-Type: text/html; charset=utf-8
";
    $headers.= "From: " . $emailSite . "
";
    $headers.= "Reply-To: " . $emailSite;
    $dest = $emailSite;
    if (mail($dest, 'Demande de permutation', $message, $headers)) {
        return true;
    } else {
        return false;
    }
}

function sendPermutConfirmMail($avocat, $newDate, $perm, $avocatPermutant, $oldDate) {
    global $urlSite;
    global $emailSite;
    $permanence = [];
    $permanence[1] = "Majeurs";
    $permanence[2] = "Mineurs";
    $permanence[3] = "Etrangers";
    $permanence[4] = "S.S.C.";
    $permanence[5] = "GAV";
    $avocat = getUserById($avocat);
    $avocatPermutant = getUserById($avocatPermutant);
    $contenu = "Bonjour Me " . $avocat["user_nom"] . ", <br/><br/>";
    $contenu.= "le bon gnie de la lampe vous informe qu'une permutation vous concernant a t accepte.<br/>";
    $contenu.= "Vous intervenez  prsent le " . date('d-m-Y', strtotime($newDate)) . " en permanence " . $permanence[$perm] . ", car vous avez chang votre permanence du " . date('d-m-Y', strtotime($oldDate)) . " avec Me " . $avocatPermutant["user_nom"] . ".<br/>";
    if ($perm != 5) {
        $mod = getModuleByDate($newDate, 'palais');
        $contenu.= "Attention, vous intervenez sur le module complet correspondant  cette date soit entre le " . date('d-m-Y', strtotime($mod["mod_start"])) . " et le " . date('d-m-Y', strtotime($mod["mod_end"])) . ".<br/>";
    }
    $contenu.= "<br/>";
    $contenu.= "Passez une excellente journe.";
    $message.= nl2br($contenu);
    $headers = "Content-Type: text/html; charset=utf-8";
    $headers.= "From: " . $emailSite . "";
    $headers.= "Reply-To: " . $emailSite;
    $dest = $avocat["user_email"];
    if (mail($dest, 'Notification de permutation', $message, $headers)) {
        return true;
    } else {
        return false;
    }
}

function sendReminderMail($dest, $nom, $date, $perm) {
    global $emailSite;
    $contenu = "Bonjour Me " . $nom . " !<br/><br/>";
    $contenu.= "Ici le bon gnie de la lampe qui te rappelle que tu es de permanence " . $perm . "  compter du " . $date . ".<br/><br/>";
    $contenu.= "Le coordinateur compte sur toi !<br><br/>";
    if ($perm == "GAV") {
        $contenu.= "Tiens-toi disponible, tlphone charg et allum, prt  partir  compter de 20h.<br/><br/>";
    }
    $contenu.= "La Permanence Pnale.";
    $message.= nl2br($contenu);
    $headers = "Content-Type: text/html; charset=utf-8";
    $headers.= "From: " . $emailSite . "";
    $headers.= "Reply-To: " . $emailSite;
    if (mail($dest, 'Rappel de permanence ' . $perm . ' le ' . $date, $message, $headers)) {
        return true;
    } else {
        return false;
    }
}

?>