<?php
function getURI(){
    $adresse = $_SERVER['PHP_SELF'];
    $i = 0;
    foreach($_GET as $cle => $valeur){
        $adresse .= ($i == 0 ? '?' : '&').$cle.($valeur ? '='.$valeur : '');
        $i++;
    }
    return "http://".$_SERVER['HTTP_HOST'].$adresse;
}

function getURL(){
	return (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
}


function checkVariable($var)
{
	if(isset($var) && $var !=""){
		return true;
	}else{
		return false;
	}
}

function checkVarGlobal($var)
{
	if(checkVariable($_GET[$var])){
		return $_GET[$var];
	}else if(checkVariable($_COOKIE["user_".$var])){
		return $_COOKIE["user_".$var];
	}else{
		return false;
	}
}

function recordArrayCookie($name,$data,$duration)
{
	$duration = 3600*24*$duration;
	$json = json_encode($data);
	if(setcookie($name, $json, time()+$duration)){
		//echo($name." ".$json." ".$duration);
	}	
}

function readArrayCookie($name)
{
	$cookie = $_COOKIE[$name];
	$cookie = stripslashes($cookie);
	$savedArray = json_decode($cookie, true);
	return $savedArray;
}

function isValidMd5($md5 = '')
{
    return preg_match('/^[a-f0-9]{32}$/', strtolower($md5));
}

function frenchDate($date){
	$temp = explode("-", $date);
	$temp2 = explode(" ", $temp[2]);
	return $temp2[0]."-".$temp[1]."-".$temp[0];
}

function datify($string){
	$annee = substr($string, 0, 4);
	$mois = substr($string, 4, 2);
	$jour = substr($string, 6, 2);
	return $annee."-".$mois."-".$jour;
}

function returnLitteralMonth($mois)
{
	$annee = ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'];
	return $annee[$mois-1];
}

function checkUser()
{
	global $cnx;
	global $IPAddress;
	//echo("checkUser()<br/>");
	//Si l'utilisateur n'est pas loggé.
	if($_SESSION['isLogged'] != 1){
		//echo("Session vide<br/>");
		//On verifie l'existence du cookie.
		if(isset($_COOKIE['cnxId'])  && $_COOKIE['cnxId'] != "" && isset($_COOKIE["cnxLog"]) && $_COOKIE["cnxLog"] != ""){
			/*echo("Cookie loging = ".$_COOKIE["cnxLog"]."<br/>");
			echo("Cookie IP = ".$IPAddress."<br/>");
			echo("Cookie idCnx = ".$_COOKIE["cnxId"]."<br/>");
			echo("COOKIE['cnxLog'].IPAddress = ".$_COOKIE["cnxLog"].$IPAddress."<br/>");
			echo("md5 = ".md5($_COOKIE["cnxLog"].$IPAddress)."<br/>");*/
			if(md5($_COOKIE["cnxLog"].$IPAddress) == $_COOKIE["cnxId"]){
				// Connexion autorisée.
				// On cherche un user avec ce login.
				$sql_query = "SELECT user_id, user_login, user_pwd, user_prenom, user_nom, user_email, user_code, user_priv_id, user_privilege_label FROM barreau_users u, barreau_users_privileges p WHERE u.user_priv_id = p.user_privilege_id AND user_login = '".$_COOKIE["cnxLog"]."'";
				$result_query = $cnx->query($sql_query);
				$result = $result_query->fetch();
				$count = $result_query->rowCount();;
				$login = $result['user_login'];
				$pwd = $result['user_pwd'];
				$result_query->closeCursor();
				// Si utilisateur trouvé
				if($count != 0){
					$cnxId = md5($result['user_login'].$IPAddress);
					$_SESSION["isLogged"] = 1;
					$_SESSION["userId"] = $result['user_id'];
					$_SESSION["userCode"] = $result['user_code'];
					$_SESSION["userLogin"] = $result['user_login'];
					$_SESSION["userPrenom"] = $result['user_prenom'];
					$_SESSION["userNom"] = $result['user_nom'];
					$_SESSION["userEmail"] = $result['user_email'];
					$_SESSION["userPrivilege"] = $result['user_priv_id'];
					$_SESSION["userTypeCompte"] = $result['user_privilege_label'];
					//Création du cookie de connexion
					setcookie("cnxId", $cnxId, time()+3600*24, "/");
					setcookie("cnxLog", $_SESSION["userLogin"], time()+3600*24, "/");
				}else{
					//echo("pas de user<br/>");
					header('Location: ?page=connexion');
				}
			}else{
				//echo("mauvais id<br/>");
				header('Location: ?page=connexion');
			}
		}else{
			//echo("Pas de cookies<br/>");
			// Pas de cookie
			header('Location: ?page=connexion');
		}
	}
}

/*
Affiche : mardi 11 septembre 2001.
echo dateToFrench("2001-09-11",'l j F Y');
*/

function dateToFrench($date, $format) 
{
    $english_days = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
    $french_days = array('lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi', 'dimanche');
    $english_months = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
    $french_months = array('janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre');
    return str_replace($english_months, $french_months, str_replace($english_days, $french_days, date($format, strtotime($date) ) ) );
}
?>